<?php
/**
 * This file is part of Google Map Polyline Encoding Tool library.
 *
 * PHP Version 5.3
 *
 * @category   Mapping
 * @package    Test
 * @subpackage PolylineTest
 * @author     E. McConville <emcconville@emcconville.com>
 * @license    https://www.gnu.org/licenses/lgpl.html GNU LGPL, version 3
 * @link       https://github.com/emcconville/google-map-polyline-encoding-tool
 */

/**
 * Primary Polyline test suite.
 *
 * Generated by PHPUnit_SkeletonGenerator on 2012-02-17 at 14:08:49.
 *
 * @category   Mapping
 * @package    Test
 * @subpackage PolylineTest
 * @author     E. McConville <emcconville@emcconville.com>
 * @license    https://www.gnu.org/licenses/lgpl.html GNU LGPL, version 3
 * @link       https://github.com/emcconville/google-map-polyline-encoding-tool
 */
class PolylineTest extends PHPUnit_Framework_TestCase
{
    protected $polylineName = "HydeParkRecords";
    protected $encoded = '}`c~FlyquOnAE?`B@|HBpGJ?@pI';
    protected $points = array(
            array(41.79999,-87.58695),
            array(41.79959,-87.58692),
            array(41.79959,-87.58741),
            array(41.79958,-87.58900),
            array(41.79956,-87.59037),
            array(41.79950,-87.59037),
            array(41.79949,-87.59206)
        );

    /**
     *  Test encode points to string
     *
     * @covers Polyline::encode
     * @covers Polyline::flatten
     *
     * @return NULL
     */
    public function testEncode()
    {
        // Remove the following lines when you implement this test.
        $this->assertEquals($this->encoded, Polyline::encode($this->points));
    }

    /**
     * Test decoding of string to points
     *
     * @covers Polyline::decode
     *
     * @return NULL
     */
    public function testDecode()
    {
        $expected = count($this->points) * 2;
        $this->assertCount($expected, Polyline::decode($this->encoded));
    }

    /**
     * Smoke test to flatten user lists.
     *
     * @covers Polyline::flatten
     *
     * @return NULL
     */
    public function testFlatten()
    {
        $paired = array(
            array(1,2),
            array(3,4),
            array(5,6)
        );
        $this->assertEquals(array(1,2,3,4,5,6), Polyline::flatten($paired));
    }

    /**
     * Smoke test to ensure tuple paring.
     *
     * @covers Polyline::pair
     *
     * @return NULL
     */
    public function testPair()
    {
        $paired = array(
            array(1,2),
            array(3,4),
            array(5,6)
        );
        $this->assertEquals($paired, Polyline::pair(array(1,2,3,4,5,6)));
    }
    /**
     * Smoke test to cover bad user import.
     *
     * @covers Polyline::pair
     *
     * @return NULL
     */
    public function testPairBadInput()
    {
        $this->assertEquals(array(), Polyline::pair('not a list'));
    }
}
