<?php
/**
 * CreateTransferResponse
 *
 * PHP version 7.4
 *
 * @category Class
 * @package  Cashfree
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * Cashfree Payout APIs
 *
 * Cashfree's Payout APIs provide developers with a streamlined pathway to integrate advanced payout capabilities into their applications, platforms and websites.
 *
 * The version of the OpenAPI document: 2024-01-01
 * Contact: developers@cashfree.com
 * Generated by: https://openapi-generator.tech
 * OpenAPI Generator version: 7.0.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace Cashfree\Model;

use \ArrayAccess;
use \Cashfree\ObjectSerializer;

/**
 * CreateTransferResponse Class Doc Comment
 *
 * @category Class
 * @description Standard Transfer V2 Response
 * @package  Cashfree
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 * @implements \ArrayAccess<string, mixed>
 */
class CreateTransferResponse implements ModelInterface, ArrayAccess, \JsonSerializable
{
    public const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $openAPIModelName = 'CreateTransferResponse';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPITypes = [
        'transfer_id' => 'string',
        'cf_transfer_id' => 'string',
        'status' => 'string',
        'beneficiary_details' => '\Cashfree\Model\CreateTransferResponseBeneficiaryDetails',
        'transfer_amount' => 'float',
        'transfer_service_charge' => 'float',
        'transfer_service_tax' => 'float',
        'transfer_mode' => 'string',
        'transfer_utr' => 'string',
        'fundsource_id' => 'string',
        'added_on' => 'string',
        'updated_on' => 'string'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      * @phpstan-var array<string, string|null>
      * @psalm-var array<string, string|null>
      */
    protected static $openAPIFormats = [
        'transfer_id' => null,
        'cf_transfer_id' => null,
        'status' => null,
        'beneficiary_details' => null,
        'transfer_amount' => 'double',
        'transfer_service_charge' => 'double',
        'transfer_service_tax' => 'double',
        'transfer_mode' => null,
        'transfer_utr' => null,
        'fundsource_id' => null,
        'added_on' => null,
        'updated_on' => null
    ];

    /**
      * Array of nullable properties. Used for (de)serialization
      *
      * @var boolean[]
      */
    protected static $openAPINullables = [
        'transfer_id' => false,
		'cf_transfer_id' => false,
		'status' => false,
		'beneficiary_details' => false,
		'transfer_amount' => false,
		'transfer_service_charge' => false,
		'transfer_service_tax' => false,
		'transfer_mode' => false,
		'transfer_utr' => false,
		'fundsource_id' => false,
		'added_on' => false,
		'updated_on' => false
    ];

    /**
      * If a nullable field gets set to null, insert it here
      *
      * @var boolean[]
      */
    protected $openAPINullablesSetToNull = [];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPITypes()
    {
        return self::$openAPITypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPIFormats()
    {
        return self::$openAPIFormats;
    }

    /**
     * Array of nullable properties
     *
     * @return array
     */
    protected static function openAPINullables(): array
    {
        return self::$openAPINullables;
    }

    /**
     * Array of nullable field names deliberately set to null
     *
     * @return boolean[]
     */
    private function getOpenAPINullablesSetToNull(): array
    {
        return $this->openAPINullablesSetToNull;
    }

    /**
     * Setter - Array of nullable field names deliberately set to null
     *
     * @param boolean[] $openAPINullablesSetToNull
     */
    private function setOpenAPINullablesSetToNull(array $openAPINullablesSetToNull): void
    {
        $this->openAPINullablesSetToNull = $openAPINullablesSetToNull;
    }

    /**
     * Checks if a property is nullable
     *
     * @param string $property
     * @return bool
     */
    public static function isNullable(string $property): bool
    {
        return self::openAPINullables()[$property] ?? false;
    }

    /**
     * Checks if a nullable property is set to null.
     *
     * @param string $property
     * @return bool
     */
    public function isNullableSetToNull(string $property): bool
    {
        return in_array($property, $this->getOpenAPINullablesSetToNull(), true);
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'transfer_id' => 'transfer_id',
        'cf_transfer_id' => 'cf_transfer_id',
        'status' => 'status',
        'beneficiary_details' => 'beneficiary_details',
        'transfer_amount' => 'transfer_amount',
        'transfer_service_charge' => 'transfer_service_charge',
        'transfer_service_tax' => 'transfer_service_tax',
        'transfer_mode' => 'transfer_mode',
        'transfer_utr' => 'transfer_utr',
        'fundsource_id' => 'fundsource_id',
        'added_on' => 'added_on',
        'updated_on' => 'updated_on'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'transfer_id' => 'setTransferId',
        'cf_transfer_id' => 'setCfTransferId',
        'status' => 'setStatus',
        'beneficiary_details' => 'setBeneficiaryDetails',
        'transfer_amount' => 'setTransferAmount',
        'transfer_service_charge' => 'setTransferServiceCharge',
        'transfer_service_tax' => 'setTransferServiceTax',
        'transfer_mode' => 'setTransferMode',
        'transfer_utr' => 'setTransferUtr',
        'fundsource_id' => 'setFundsourceId',
        'added_on' => 'setAddedOn',
        'updated_on' => 'setUpdatedOn'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'transfer_id' => 'getTransferId',
        'cf_transfer_id' => 'getCfTransferId',
        'status' => 'getStatus',
        'beneficiary_details' => 'getBeneficiaryDetails',
        'transfer_amount' => 'getTransferAmount',
        'transfer_service_charge' => 'getTransferServiceCharge',
        'transfer_service_tax' => 'getTransferServiceTax',
        'transfer_mode' => 'getTransferMode',
        'transfer_utr' => 'getTransferUtr',
        'fundsource_id' => 'getFundsourceId',
        'added_on' => 'getAddedOn',
        'updated_on' => 'getUpdatedOn'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$openAPIModelName;
    }


    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[] $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(array $data = null)
    {
        $this->setIfExists('transfer_id', $data ?? [], null);
        $this->setIfExists('cf_transfer_id', $data ?? [], null);
        $this->setIfExists('status', $data ?? [], null);
        $this->setIfExists('beneficiary_details', $data ?? [], null);
        $this->setIfExists('transfer_amount', $data ?? [], null);
        $this->setIfExists('transfer_service_charge', $data ?? [], null);
        $this->setIfExists('transfer_service_tax', $data ?? [], null);
        $this->setIfExists('transfer_mode', $data ?? [], null);
        $this->setIfExists('transfer_utr', $data ?? [], null);
        $this->setIfExists('fundsource_id', $data ?? [], null);
        $this->setIfExists('added_on', $data ?? [], null);
        $this->setIfExists('updated_on', $data ?? [], null);
    }

    /**
    * Sets $this->container[$variableName] to the given data or to the given default Value; if $variableName
    * is nullable and its value is set to null in the $fields array, then mark it as "set to null" in the
    * $this->openAPINullablesSetToNull array
    *
    * @param string $variableName
    * @param array  $fields
    * @param mixed  $defaultValue
    */
    private function setIfExists(string $variableName, array $fields, $defaultValue): void
    {
        if (self::isNullable($variableName) && array_key_exists($variableName, $fields) && is_null($fields[$variableName])) {
            $this->openAPINullablesSetToNull[] = $variableName;
        }

        $this->container[$variableName] = $fields[$variableName] ?? $defaultValue;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets transfer_id
     *
     * @return string|null
     */
    public function getTransferId()
    {
        return $this->container['transfer_id'];
    }

    /**
     * Sets transfer_id
     *
     * @param string|null $transfer_id It displays the unique ID you created to identify the transfer.
     *
     * @return self
     */
    public function setTransferId($transfer_id)
    {
        if (is_null($transfer_id)) {
            throw new \InvalidArgumentException('non-nullable transfer_id cannot be null');
        }
        $this->container['transfer_id'] = $transfer_id;

        return $this;
    }

    /**
     * Gets cf_transfer_id
     *
     * @return string|null
     */
    public function getCfTransferId()
    {
        return $this->container['cf_transfer_id'];
    }

    /**
     * Sets cf_transfer_id
     *
     * @param string|null $cf_transfer_id It displays the unique ID created by Cashfree Payments. You receive this ID in the response after initiating the standard transfer request.
     *
     * @return self
     */
    public function setCfTransferId($cf_transfer_id)
    {
        if (is_null($cf_transfer_id)) {
            throw new \InvalidArgumentException('non-nullable cf_transfer_id cannot be null');
        }
        $this->container['cf_transfer_id'] = $cf_transfer_id;

        return $this;
    }

    /**
     * Gets status
     *
     * @return string|null
     */
    public function getStatus()
    {
        return $this->container['status'];
    }

    /**
     * Sets status
     *
     * @param string|null $status It displays the status of the transfer.
     *
     * @return self
     */
    public function setStatus($status)
    {
        if (is_null($status)) {
            throw new \InvalidArgumentException('non-nullable status cannot be null');
        }
        $this->container['status'] = $status;

        return $this;
    }

    /**
     * Gets beneficiary_details
     *
     * @return \Cashfree\Model\CreateTransferResponseBeneficiaryDetails|null
     */
    public function getBeneficiaryDetails()
    {
        return $this->container['beneficiary_details'];
    }

    /**
     * Sets beneficiary_details
     *
     * @param \Cashfree\Model\CreateTransferResponseBeneficiaryDetails|null $beneficiary_details beneficiary_details
     *
     * @return self
     */
    public function setBeneficiaryDetails($beneficiary_details)
    {
        if (is_null($beneficiary_details)) {
            throw new \InvalidArgumentException('non-nullable beneficiary_details cannot be null');
        }
        $this->container['beneficiary_details'] = $beneficiary_details;

        return $this;
    }

    /**
     * Gets transfer_amount
     *
     * @return float|null
     */
    public function getTransferAmount()
    {
        return $this->container['transfer_amount'];
    }

    /**
     * Sets transfer_amount
     *
     * @param float|null $transfer_amount It displays the transfer amount initiated in the request.
     *
     * @return self
     */
    public function setTransferAmount($transfer_amount)
    {
        if (is_null($transfer_amount)) {
            throw new \InvalidArgumentException('non-nullable transfer_amount cannot be null');
        }
        $this->container['transfer_amount'] = $transfer_amount;

        return $this;
    }

    /**
     * Gets transfer_service_charge
     *
     * @return float|null
     */
    public function getTransferServiceCharge()
    {
        return $this->container['transfer_service_charge'];
    }

    /**
     * Sets transfer_service_charge
     *
     * @param float|null $transfer_service_charge It displays the service charge applicable for the successful transfer request.
     *
     * @return self
     */
    public function setTransferServiceCharge($transfer_service_charge)
    {
        if (is_null($transfer_service_charge)) {
            throw new \InvalidArgumentException('non-nullable transfer_service_charge cannot be null');
        }
        $this->container['transfer_service_charge'] = $transfer_service_charge;

        return $this;
    }

    /**
     * Gets transfer_service_tax
     *
     * @return float|null
     */
    public function getTransferServiceTax()
    {
        return $this->container['transfer_service_tax'];
    }

    /**
     * Sets transfer_service_tax
     *
     * @param float|null $transfer_service_tax It displays the service tax applicable for the successful transfer request.
     *
     * @return self
     */
    public function setTransferServiceTax($transfer_service_tax)
    {
        if (is_null($transfer_service_tax)) {
            throw new \InvalidArgumentException('non-nullable transfer_service_tax cannot be null');
        }
        $this->container['transfer_service_tax'] = $transfer_service_tax;

        return $this;
    }

    /**
     * Gets transfer_mode
     *
     * @return string|null
     */
    public function getTransferMode()
    {
        return $this->container['transfer_mode'];
    }

    /**
     * Sets transfer_mode
     *
     * @param string|null $transfer_mode It displays the mode of the transfer.
     *
     * @return self
     */
    public function setTransferMode($transfer_mode)
    {
        if (is_null($transfer_mode)) {
            throw new \InvalidArgumentException('non-nullable transfer_mode cannot be null');
        }
        $this->container['transfer_mode'] = $transfer_mode;

        return $this;
    }

    /**
     * Gets transfer_utr
     *
     * @return string|null
     */
    public function getTransferUtr()
    {
        return $this->container['transfer_utr'];
    }

    /**
     * Sets transfer_utr
     *
     * @param string|null $transfer_utr It displays the unique number that is generated to recognise any fund transfer that is created by the bank that facilitates the transfer.
     *
     * @return self
     */
    public function setTransferUtr($transfer_utr)
    {
        if (is_null($transfer_utr)) {
            throw new \InvalidArgumentException('non-nullable transfer_utr cannot be null');
        }
        $this->container['transfer_utr'] = $transfer_utr;

        return $this;
    }

    /**
     * Gets fundsource_id
     *
     * @return string|null
     */
    public function getFundsourceId()
    {
        return $this->container['fundsource_id'];
    }

    /**
     * Sets fundsource_id
     *
     * @param string|null $fundsource_id It displays the ID of the fund source from where the money was debited for this transfer request.
     *
     * @return self
     */
    public function setFundsourceId($fundsource_id)
    {
        if (is_null($fundsource_id)) {
            throw new \InvalidArgumentException('non-nullable fundsource_id cannot be null');
        }
        $this->container['fundsource_id'] = $fundsource_id;

        return $this;
    }

    /**
     * Gets added_on
     *
     * @return string|null
     */
    public function getAddedOn()
    {
        return $this->container['added_on'];
    }

    /**
     * Sets added_on
     *
     * @param string|null $added_on It displays the time of when the transfer request was added to the system.
     *
     * @return self
     */
    public function setAddedOn($added_on)
    {
        if (is_null($added_on)) {
            throw new \InvalidArgumentException('non-nullable added_on cannot be null');
        }
        $this->container['added_on'] = $added_on;

        return $this;
    }

    /**
     * Gets updated_on
     *
     * @return string|null
     */
    public function getUpdatedOn()
    {
        return $this->container['updated_on'];
    }

    /**
     * Sets updated_on
     *
     * @param string|null $updated_on It displays the updated time for the transfer.
     *
     * @return self
     */
    public function setUpdatedOn($updated_on)
    {
        if (is_null($updated_on)) {
            throw new \InvalidArgumentException('non-nullable updated_on cannot be null');
        }
        $this->container['updated_on'] = $updated_on;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer $offset Offset
     *
     * @return boolean
     */
    public function offsetExists($offset): bool
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer $offset Offset
     *
     * @return mixed|null
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset)
    {
        return $this->container[$offset] ?? null;
    }

    /**
     * Sets value based on offset.
     *
     * @param int|null $offset Offset
     * @param mixed    $value  Value to be set
     *
     * @return void
     */
    public function offsetSet($offset, $value): void
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer $offset Offset
     *
     * @return void
     */
    public function offsetUnset($offset): void
    {
        unset($this->container[$offset]);
    }

    /**
     * Serializes the object to a value that can be serialized natively by json_encode().
     * @link https://www.php.net/manual/en/jsonserializable.jsonserialize.php
     *
     * @return mixed Returns data which can be serialized by json_encode(), which is a value
     * of any type other than a resource.
     */
    #[\ReturnTypeWillChange]
    public function jsonSerialize()
    {
       return ObjectSerializer::sanitizeForSerialization($this);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        return json_encode(
            ObjectSerializer::sanitizeForSerialization($this),
            JSON_PRETTY_PRINT
        );
    }

    /**
     * Gets a header-safe presentation of the object
     *
     * @return string
     */
    public function toHeaderValue()
    {
        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}


