<?php
/**
 * CreateTransferRequestBeneficiaryDetailsBeneficiaryInstrumentDetailsCardDetails
 *
 * PHP version 7.4
 *
 * @category Class
 * @package  Cashfree
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * Cashfree Payout APIs
 *
 * Cashfree's Payout APIs provide developers with a streamlined pathway to integrate advanced payout capabilities into their applications, platforms and websites.
 *
 * The version of the OpenAPI document: 2024-01-01
 * Contact: developers@cashfree.com
 * Generated by: https://openapi-generator.tech
 * OpenAPI Generator version: 7.0.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace Cashfree\Model;

use \ArrayAccess;
use \Cashfree\ObjectSerializer;

/**
 * CreateTransferRequestBeneficiaryDetailsBeneficiaryInstrumentDetailsCardDetails Class Doc Comment
 *
 * @category Class
 * @description It should contain the card details of the beneficiary.
 * @package  Cashfree
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 * @implements \ArrayAccess<string, mixed>
 */
class CreateTransferRequestBeneficiaryDetailsBeneficiaryInstrumentDetailsCardDetails implements ModelInterface, ArrayAccess, \JsonSerializable
{
    public const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $openAPIModelName = 'CreateTransferRequest_beneficiary_details_beneficiary_instrument_details_card_details';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPITypes = [
        'card_token' => 'string',
        'card_network_type' => 'string',
        'card_cryptogram' => 'string',
        'card_token_expiry' => 'string',
        'card_type' => 'string',
        'card_token_pan_sequence_number' => 'string'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      * @phpstan-var array<string, string|null>
      * @psalm-var array<string, string|null>
      */
    protected static $openAPIFormats = [
        'card_token' => null,
        'card_network_type' => null,
        'card_cryptogram' => null,
        'card_token_expiry' => null,
        'card_type' => null,
        'card_token_pan_sequence_number' => null
    ];

    /**
      * Array of nullable properties. Used for (de)serialization
      *
      * @var boolean[]
      */
    protected static $openAPINullables = [
        'card_token' => false,
		'card_network_type' => false,
		'card_cryptogram' => false,
		'card_token_expiry' => false,
		'card_type' => false,
		'card_token_pan_sequence_number' => false
    ];

    /**
      * If a nullable field gets set to null, insert it here
      *
      * @var boolean[]
      */
    protected $openAPINullablesSetToNull = [];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPITypes()
    {
        return self::$openAPITypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPIFormats()
    {
        return self::$openAPIFormats;
    }

    /**
     * Array of nullable properties
     *
     * @return array
     */
    protected static function openAPINullables(): array
    {
        return self::$openAPINullables;
    }

    /**
     * Array of nullable field names deliberately set to null
     *
     * @return boolean[]
     */
    private function getOpenAPINullablesSetToNull(): array
    {
        return $this->openAPINullablesSetToNull;
    }

    /**
     * Setter - Array of nullable field names deliberately set to null
     *
     * @param boolean[] $openAPINullablesSetToNull
     */
    private function setOpenAPINullablesSetToNull(array $openAPINullablesSetToNull): void
    {
        $this->openAPINullablesSetToNull = $openAPINullablesSetToNull;
    }

    /**
     * Checks if a property is nullable
     *
     * @param string $property
     * @return bool
     */
    public static function isNullable(string $property): bool
    {
        return self::openAPINullables()[$property] ?? false;
    }

    /**
     * Checks if a nullable property is set to null.
     *
     * @param string $property
     * @return bool
     */
    public function isNullableSetToNull(string $property): bool
    {
        return in_array($property, $this->getOpenAPINullablesSetToNull(), true);
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'card_token' => 'card_token',
        'card_network_type' => 'card_network_type',
        'card_cryptogram' => 'card_cryptogram',
        'card_token_expiry' => 'card_token_expiry',
        'card_type' => 'card_type',
        'card_token_pan_sequence_number' => 'card_token_PAN_sequence_number'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'card_token' => 'setCardToken',
        'card_network_type' => 'setCardNetworkType',
        'card_cryptogram' => 'setCardCryptogram',
        'card_token_expiry' => 'setCardTokenExpiry',
        'card_type' => 'setCardType',
        'card_token_pan_sequence_number' => 'setCardTokenPanSequenceNumber'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'card_token' => 'getCardToken',
        'card_network_type' => 'getCardNetworkType',
        'card_cryptogram' => 'getCardCryptogram',
        'card_token_expiry' => 'getCardTokenExpiry',
        'card_type' => 'getCardType',
        'card_token_pan_sequence_number' => 'getCardTokenPanSequenceNumber'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$openAPIModelName;
    }

    public const CARD_NETWORK_TYPE_VISA = 'VISA';
    public const CARD_NETWORK_TYPE_MASTERCARD = 'MASTERCARD';
    public const CARD_NETWORK_TYPE_UNKNOWN_DEFAULT_OPEN_API = 'unknown_default_open_api';

    /**
     * Gets allowable values of the enum
     *
     * @return string[]
     */
    public function getCardNetworkTypeAllowableValues()
    {
        return [
            self::CARD_NETWORK_TYPE_VISA,
            self::CARD_NETWORK_TYPE_MASTERCARD,
            self::CARD_NETWORK_TYPE_UNKNOWN_DEFAULT_OPEN_API,
        ];
    }

    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[] $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(array $data = null)
    {
        $this->setIfExists('card_token', $data ?? [], null);
        $this->setIfExists('card_network_type', $data ?? [], null);
        $this->setIfExists('card_cryptogram', $data ?? [], null);
        $this->setIfExists('card_token_expiry', $data ?? [], null);
        $this->setIfExists('card_type', $data ?? [], null);
        $this->setIfExists('card_token_pan_sequence_number', $data ?? [], null);
    }

    /**
    * Sets $this->container[$variableName] to the given data or to the given default Value; if $variableName
    * is nullable and its value is set to null in the $fields array, then mark it as "set to null" in the
    * $this->openAPINullablesSetToNull array
    *
    * @param string $variableName
    * @param array  $fields
    * @param mixed  $defaultValue
    */
    private function setIfExists(string $variableName, array $fields, $defaultValue): void
    {
        if (self::isNullable($variableName) && array_key_exists($variableName, $fields) && is_null($fields[$variableName])) {
            $this->openAPINullablesSetToNull[] = $variableName;
        }

        $this->container[$variableName] = $fields[$variableName] ?? $defaultValue;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        $allowedValues = $this->getCardNetworkTypeAllowableValues();
        if (!is_null($this->container['card_network_type']) && !in_array($this->container['card_network_type'], $allowedValues, true)) {
            $invalidProperties[] = sprintf(
                "invalid value '%s' for 'card_network_type', must be one of '%s'",
                $this->container['card_network_type'],
                implode("', '", $allowedValues)
            );
        }

        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets card_token
     *
     * @return string|null
     */
    public function getCardToken()
    {
        return $this->container['card_token'];
    }

    /**
     * Sets card_token
     *
     * @param string|null $card_token It is the tokenised card number or card token for this transfer.
     *
     * @return self
     */
    public function setCardToken($card_token)
    {
        if (is_null($card_token)) {
            throw new \InvalidArgumentException('non-nullable card_token cannot be null');
        }
        $this->container['card_token'] = $card_token;

        return $this;
    }

    /**
     * Gets card_network_type
     *
     * @return string|null
     */
    public function getCardNetworkType()
    {
        return $this->container['card_network_type'];
    }

    /**
     * Sets card_network_type
     *
     * @param string|null $card_network_type It is the network type of the card - VISA/MASTERCARD.
     *
     * @return self
     */
    public function setCardNetworkType($card_network_type)
    {
        if (is_null($card_network_type)) {
            throw new \InvalidArgumentException('non-nullable card_network_type cannot be null');
        }
        $allowedValues = $this->getCardNetworkTypeAllowableValues();
        if (!in_array($card_network_type, $allowedValues, true)) {
            throw new \InvalidArgumentException(
                sprintf(
                    "Invalid value '%s' for 'card_network_type', must be one of '%s'",
                    $card_network_type,
                    implode("', '", $allowedValues)
                )
            );
        }
        $this->container['card_network_type'] = $card_network_type;

        return $this;
    }

    /**
     * Gets card_cryptogram
     *
     * @return string|null
     */
    public function getCardCryptogram()
    {
        return $this->container['card_cryptogram'];
    }

    /**
     * Sets card_cryptogram
     *
     * @param string|null $card_cryptogram It is the formatted chip/cryptogram data relating to the token cryptogram. The maximum character limit is 600. It is optional for MASTERCARD and not required for VISA.
     *
     * @return self
     */
    public function setCardCryptogram($card_cryptogram)
    {
        if (is_null($card_cryptogram)) {
            throw new \InvalidArgumentException('non-nullable card_cryptogram cannot be null');
        }
        $this->container['card_cryptogram'] = $card_cryptogram;

        return $this;
    }

    /**
     * Gets card_token_expiry
     *
     * @return string|null
     */
    public function getCardTokenExpiry()
    {
        return $this->container['card_token_expiry'];
    }

    /**
     * Sets card_token_expiry
     *
     * @param string|null $card_token_expiry It is applicable only for MASTERCARD. The format for the valid token expiry date should be YYYY-MM. It cannot be null. Provide a valid tokenExpiry if collected from the customers. If unavailable, populate a static value with a forward year and month in the correct format (YYYY-MM). The maximum character limit is 10.
     *
     * @return self
     */
    public function setCardTokenExpiry($card_token_expiry)
    {
        if (is_null($card_token_expiry)) {
            throw new \InvalidArgumentException('non-nullable card_token_expiry cannot be null');
        }
        $this->container['card_token_expiry'] = $card_token_expiry;

        return $this;
    }

    /**
     * Gets card_type
     *
     * @return string|null
     */
    public function getCardType()
    {
        return $this->container['card_type'];
    }

    /**
     * Sets card_type
     *
     * @param string|null $card_type It is the type of the card. DEBIT and CREDIT are the only values allowed. The default value is CREDIT if the parameter does not exist or not specified.
     *
     * @return self
     */
    public function setCardType($card_type)
    {
        if (is_null($card_type)) {
            throw new \InvalidArgumentException('non-nullable card_type cannot be null');
        }
        $this->container['card_type'] = $card_type;

        return $this;
    }

    /**
     * Gets card_token_pan_sequence_number
     *
     * @return string|null
     */
    public function getCardTokenPanSequenceNumber()
    {
        return $this->container['card_token_pan_sequence_number'];
    }

    /**
     * Sets card_token_pan_sequence_number
     *
     * @param string|null $card_token_pan_sequence_number A maximum of 3 alphanumeric characters are allowed. It is an optional parameter for MASTERCARD.
     *
     * @return self
     */
    public function setCardTokenPanSequenceNumber($card_token_pan_sequence_number)
    {
        if (is_null($card_token_pan_sequence_number)) {
            throw new \InvalidArgumentException('non-nullable card_token_pan_sequence_number cannot be null');
        }
        $this->container['card_token_pan_sequence_number'] = $card_token_pan_sequence_number;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer $offset Offset
     *
     * @return boolean
     */
    public function offsetExists($offset): bool
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer $offset Offset
     *
     * @return mixed|null
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset)
    {
        return $this->container[$offset] ?? null;
    }

    /**
     * Sets value based on offset.
     *
     * @param int|null $offset Offset
     * @param mixed    $value  Value to be set
     *
     * @return void
     */
    public function offsetSet($offset, $value): void
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer $offset Offset
     *
     * @return void
     */
    public function offsetUnset($offset): void
    {
        unset($this->container[$offset]);
    }

    /**
     * Serializes the object to a value that can be serialized natively by json_encode().
     * @link https://www.php.net/manual/en/jsonserializable.jsonserialize.php
     *
     * @return mixed Returns data which can be serialized by json_encode(), which is a value
     * of any type other than a resource.
     */
    #[\ReturnTypeWillChange]
    public function jsonSerialize()
    {
       return ObjectSerializer::sanitizeForSerialization($this);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        return json_encode(
            ObjectSerializer::sanitizeForSerialization($this),
            JSON_PRETTY_PRINT
        );
    }

    /**
     * Gets a header-safe presentation of the object
     *
     * @return string
     */
    public function toHeaderValue()
    {
        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}


