<?php
/**
 * CreateTransferRequestBeneficiaryDetails
 *
 * PHP version 7.4
 *
 * @category Class
 * @package  Cashfree
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * Cashfree Payout APIs
 *
 * Cashfree's Payout APIs provide developers with a streamlined pathway to integrate advanced payout capabilities into their applications, platforms and websites.
 *
 * The version of the OpenAPI document: 2024-01-01
 * Contact: developers@cashfree.com
 * Generated by: https://openapi-generator.tech
 * OpenAPI Generator version: 7.0.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace Cashfree\Model;

use \ArrayAccess;
use \Cashfree\ObjectSerializer;

/**
 * CreateTransferRequestBeneficiaryDetails Class Doc Comment
 *
 * @category Class
 * @description It should contain the details of the beneficiary who receives the transfer amount.
 * @package  Cashfree
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 * @implements \ArrayAccess<string, mixed>
 */
class CreateTransferRequestBeneficiaryDetails implements ModelInterface, ArrayAccess, \JsonSerializable
{
    public const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $openAPIModelName = 'CreateTransferRequest_beneficiary_details';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPITypes = [
        'beneficiary_id' => 'string',
        'beneficiary_name' => 'string',
        'beneficiary_instrument_details' => '\Cashfree\Model\CreateTransferRequestBeneficiaryDetailsBeneficiaryInstrumentDetails',
        'beneficiary_contact_details' => '\Cashfree\Model\CreateTransferRequestBeneficiaryDetailsBeneficiaryContactDetails'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      * @phpstan-var array<string, string|null>
      * @psalm-var array<string, string|null>
      */
    protected static $openAPIFormats = [
        'beneficiary_id' => null,
        'beneficiary_name' => null,
        'beneficiary_instrument_details' => null,
        'beneficiary_contact_details' => null
    ];

    /**
      * Array of nullable properties. Used for (de)serialization
      *
      * @var boolean[]
      */
    protected static $openAPINullables = [
        'beneficiary_id' => false,
		'beneficiary_name' => false,
		'beneficiary_instrument_details' => false,
		'beneficiary_contact_details' => false
    ];

    /**
      * If a nullable field gets set to null, insert it here
      *
      * @var boolean[]
      */
    protected $openAPINullablesSetToNull = [];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPITypes()
    {
        return self::$openAPITypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPIFormats()
    {
        return self::$openAPIFormats;
    }

    /**
     * Array of nullable properties
     *
     * @return array
     */
    protected static function openAPINullables(): array
    {
        return self::$openAPINullables;
    }

    /**
     * Array of nullable field names deliberately set to null
     *
     * @return boolean[]
     */
    private function getOpenAPINullablesSetToNull(): array
    {
        return $this->openAPINullablesSetToNull;
    }

    /**
     * Setter - Array of nullable field names deliberately set to null
     *
     * @param boolean[] $openAPINullablesSetToNull
     */
    private function setOpenAPINullablesSetToNull(array $openAPINullablesSetToNull): void
    {
        $this->openAPINullablesSetToNull = $openAPINullablesSetToNull;
    }

    /**
     * Checks if a property is nullable
     *
     * @param string $property
     * @return bool
     */
    public static function isNullable(string $property): bool
    {
        return self::openAPINullables()[$property] ?? false;
    }

    /**
     * Checks if a nullable property is set to null.
     *
     * @param string $property
     * @return bool
     */
    public function isNullableSetToNull(string $property): bool
    {
        return in_array($property, $this->getOpenAPINullablesSetToNull(), true);
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'beneficiary_id' => 'beneficiary_id',
        'beneficiary_name' => 'beneficiary_name',
        'beneficiary_instrument_details' => 'beneficiary_instrument_details',
        'beneficiary_contact_details' => 'beneficiary_contact_details'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'beneficiary_id' => 'setBeneficiaryId',
        'beneficiary_name' => 'setBeneficiaryName',
        'beneficiary_instrument_details' => 'setBeneficiaryInstrumentDetails',
        'beneficiary_contact_details' => 'setBeneficiaryContactDetails'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'beneficiary_id' => 'getBeneficiaryId',
        'beneficiary_name' => 'getBeneficiaryName',
        'beneficiary_instrument_details' => 'getBeneficiaryInstrumentDetails',
        'beneficiary_contact_details' => 'getBeneficiaryContactDetails'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$openAPIModelName;
    }


    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[] $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(array $data = null)
    {
        $this->setIfExists('beneficiary_id', $data ?? [], null);
        $this->setIfExists('beneficiary_name', $data ?? [], null);
        $this->setIfExists('beneficiary_instrument_details', $data ?? [], null);
        $this->setIfExists('beneficiary_contact_details', $data ?? [], null);
    }

    /**
    * Sets $this->container[$variableName] to the given data or to the given default Value; if $variableName
    * is nullable and its value is set to null in the $fields array, then mark it as "set to null" in the
    * $this->openAPINullablesSetToNull array
    *
    * @param string $variableName
    * @param array  $fields
    * @param mixed  $defaultValue
    */
    private function setIfExists(string $variableName, array $fields, $defaultValue): void
    {
        if (self::isNullable($variableName) && array_key_exists($variableName, $fields) && is_null($fields[$variableName])) {
            $this->openAPINullablesSetToNull[] = $variableName;
        }

        $this->container[$variableName] = $fields[$variableName] ?? $defaultValue;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets beneficiary_id
     *
     * @return string|null
     */
    public function getBeneficiaryId()
    {
        return $this->container['beneficiary_id'];
    }

    /**
     * Sets beneficiary_id
     *
     * @param string|null $beneficiary_id It is the unique ID you created to identify the beneficiary. Alphanumeric characters are allowed.
     *
     * @return self
     */
    public function setBeneficiaryId($beneficiary_id)
    {
        if (is_null($beneficiary_id)) {
            throw new \InvalidArgumentException('non-nullable beneficiary_id cannot be null');
        }
        $this->container['beneficiary_id'] = $beneficiary_id;

        return $this;
    }

    /**
     * Gets beneficiary_name
     *
     * @return string|null
     */
    public function getBeneficiaryName()
    {
        return $this->container['beneficiary_name'];
    }

    /**
     * Sets beneficiary_name
     *
     * @param string|null $beneficiary_name It is the name of the beneficiary. The maximum character limit is 100.  Only alphabets and whitespaces are allowed. It is required if beneficiary_id is not present.
     *
     * @return self
     */
    public function setBeneficiaryName($beneficiary_name)
    {
        if (is_null($beneficiary_name)) {
            throw new \InvalidArgumentException('non-nullable beneficiary_name cannot be null');
        }
        $this->container['beneficiary_name'] = $beneficiary_name;

        return $this;
    }

    /**
     * Gets beneficiary_instrument_details
     *
     * @return \Cashfree\Model\CreateTransferRequestBeneficiaryDetailsBeneficiaryInstrumentDetails|null
     */
    public function getBeneficiaryInstrumentDetails()
    {
        return $this->container['beneficiary_instrument_details'];
    }

    /**
     * Sets beneficiary_instrument_details
     *
     * @param \Cashfree\Model\CreateTransferRequestBeneficiaryDetailsBeneficiaryInstrumentDetails|null $beneficiary_instrument_details beneficiary_instrument_details
     *
     * @return self
     */
    public function setBeneficiaryInstrumentDetails($beneficiary_instrument_details)
    {
        if (is_null($beneficiary_instrument_details)) {
            throw new \InvalidArgumentException('non-nullable beneficiary_instrument_details cannot be null');
        }
        $this->container['beneficiary_instrument_details'] = $beneficiary_instrument_details;

        return $this;
    }

    /**
     * Gets beneficiary_contact_details
     *
     * @return \Cashfree\Model\CreateTransferRequestBeneficiaryDetailsBeneficiaryContactDetails|null
     */
    public function getBeneficiaryContactDetails()
    {
        return $this->container['beneficiary_contact_details'];
    }

    /**
     * Sets beneficiary_contact_details
     *
     * @param \Cashfree\Model\CreateTransferRequestBeneficiaryDetailsBeneficiaryContactDetails|null $beneficiary_contact_details beneficiary_contact_details
     *
     * @return self
     */
    public function setBeneficiaryContactDetails($beneficiary_contact_details)
    {
        if (is_null($beneficiary_contact_details)) {
            throw new \InvalidArgumentException('non-nullable beneficiary_contact_details cannot be null');
        }
        $this->container['beneficiary_contact_details'] = $beneficiary_contact_details;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer $offset Offset
     *
     * @return boolean
     */
    public function offsetExists($offset): bool
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer $offset Offset
     *
     * @return mixed|null
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset)
    {
        return $this->container[$offset] ?? null;
    }

    /**
     * Sets value based on offset.
     *
     * @param int|null $offset Offset
     * @param mixed    $value  Value to be set
     *
     * @return void
     */
    public function offsetSet($offset, $value): void
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer $offset Offset
     *
     * @return void
     */
    public function offsetUnset($offset): void
    {
        unset($this->container[$offset]);
    }

    /**
     * Serializes the object to a value that can be serialized natively by json_encode().
     * @link https://www.php.net/manual/en/jsonserializable.jsonserialize.php
     *
     * @return mixed Returns data which can be serialized by json_encode(), which is a value
     * of any type other than a resource.
     */
    #[\ReturnTypeWillChange]
    public function jsonSerialize()
    {
       return ObjectSerializer::sanitizeForSerialization($this);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        return json_encode(
            ObjectSerializer::sanitizeForSerialization($this),
            JSON_PRETTY_PRINT
        );
    }

    /**
     * Gets a header-safe presentation of the object
     *
     * @return string
     */
    public function toHeaderValue()
    {
        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}


