<?php
/**
 * CreateBatchTransferRequestTransfersInner
 *
 * PHP version 7.4
 *
 * @category Class
 * @package  Cashfree
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * Cashfree Payout APIs
 *
 * Cashfree's Payout APIs provide developers with a streamlined pathway to integrate advanced payout capabilities into their applications, platforms and websites.
 *
 * The version of the OpenAPI document: 2024-01-01
 * Contact: developers@cashfree.com
 * Generated by: https://openapi-generator.tech
 * OpenAPI Generator version: 7.0.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace Cashfree\Model;

use \ArrayAccess;
use \Cashfree\ObjectSerializer;

/**
 * CreateBatchTransferRequestTransfersInner Class Doc Comment
 *
 * @category Class
 * @package  Cashfree
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 * @implements \ArrayAccess<string, mixed>
 */
class CreateBatchTransferRequestTransfersInner implements ModelInterface, ArrayAccess, \JsonSerializable
{
    public const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $openAPIModelName = 'CreateBatchTransferRequest_transfers_inner';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPITypes = [
        'transfer_id' => 'string',
        'transfer_amount' => 'float',
        'transfer_currency' => 'string',
        'transfer_mode' => 'string',
        'beneficiary_details' => '\Cashfree\Model\CreateBatchTransferRequestTransfersInnerBeneficiaryDetails',
        'transfer_remarks' => 'string',
        'fundsource_id' => 'string'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      * @phpstan-var array<string, string|null>
      * @psalm-var array<string, string|null>
      */
    protected static $openAPIFormats = [
        'transfer_id' => null,
        'transfer_amount' => 'double',
        'transfer_currency' => null,
        'transfer_mode' => null,
        'beneficiary_details' => null,
        'transfer_remarks' => null,
        'fundsource_id' => null
    ];

    /**
      * Array of nullable properties. Used for (de)serialization
      *
      * @var boolean[]
      */
    protected static $openAPINullables = [
        'transfer_id' => false,
		'transfer_amount' => false,
		'transfer_currency' => false,
		'transfer_mode' => false,
		'beneficiary_details' => false,
		'transfer_remarks' => false,
		'fundsource_id' => false
    ];

    /**
      * If a nullable field gets set to null, insert it here
      *
      * @var boolean[]
      */
    protected $openAPINullablesSetToNull = [];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPITypes()
    {
        return self::$openAPITypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPIFormats()
    {
        return self::$openAPIFormats;
    }

    /**
     * Array of nullable properties
     *
     * @return array
     */
    protected static function openAPINullables(): array
    {
        return self::$openAPINullables;
    }

    /**
     * Array of nullable field names deliberately set to null
     *
     * @return boolean[]
     */
    private function getOpenAPINullablesSetToNull(): array
    {
        return $this->openAPINullablesSetToNull;
    }

    /**
     * Setter - Array of nullable field names deliberately set to null
     *
     * @param boolean[] $openAPINullablesSetToNull
     */
    private function setOpenAPINullablesSetToNull(array $openAPINullablesSetToNull): void
    {
        $this->openAPINullablesSetToNull = $openAPINullablesSetToNull;
    }

    /**
     * Checks if a property is nullable
     *
     * @param string $property
     * @return bool
     */
    public static function isNullable(string $property): bool
    {
        return self::openAPINullables()[$property] ?? false;
    }

    /**
     * Checks if a nullable property is set to null.
     *
     * @param string $property
     * @return bool
     */
    public function isNullableSetToNull(string $property): bool
    {
        return in_array($property, $this->getOpenAPINullablesSetToNull(), true);
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'transfer_id' => 'transfer_id',
        'transfer_amount' => 'transfer_amount',
        'transfer_currency' => 'transfer_currency',
        'transfer_mode' => 'transfer_mode',
        'beneficiary_details' => 'beneficiary_details',
        'transfer_remarks' => 'transfer_remarks',
        'fundsource_id' => 'fundsource_id'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'transfer_id' => 'setTransferId',
        'transfer_amount' => 'setTransferAmount',
        'transfer_currency' => 'setTransferCurrency',
        'transfer_mode' => 'setTransferMode',
        'beneficiary_details' => 'setBeneficiaryDetails',
        'transfer_remarks' => 'setTransferRemarks',
        'fundsource_id' => 'setFundsourceId'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'transfer_id' => 'getTransferId',
        'transfer_amount' => 'getTransferAmount',
        'transfer_currency' => 'getTransferCurrency',
        'transfer_mode' => 'getTransferMode',
        'beneficiary_details' => 'getBeneficiaryDetails',
        'transfer_remarks' => 'getTransferRemarks',
        'fundsource_id' => 'getFundsourceId'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$openAPIModelName;
    }

    public const TRANSFER_MODE_BANKTRANSFER = 'banktransfer';
    public const TRANSFER_MODE_IMPS = 'imps';
    public const TRANSFER_MODE_NEFT = 'neft';
    public const TRANSFER_MODE_RTGS = 'rtgs';
    public const TRANSFER_MODE_UPI = 'upi';
    public const TRANSFER_MODE_PAYTM = 'paytm';
    public const TRANSFER_MODE_AMAZONPAY = 'amazonpay';
    public const TRANSFER_MODE_CARD = 'card';
    public const TRANSFER_MODE_CARDUPI = 'cardupi';
    public const TRANSFER_MODE_UNKNOWN_DEFAULT_OPEN_API = 'unknown_default_open_api';

    /**
     * Gets allowable values of the enum
     *
     * @return string[]
     */
    public function getTransferModeAllowableValues()
    {
        return [
            self::TRANSFER_MODE_BANKTRANSFER,
            self::TRANSFER_MODE_IMPS,
            self::TRANSFER_MODE_NEFT,
            self::TRANSFER_MODE_RTGS,
            self::TRANSFER_MODE_UPI,
            self::TRANSFER_MODE_PAYTM,
            self::TRANSFER_MODE_AMAZONPAY,
            self::TRANSFER_MODE_CARD,
            self::TRANSFER_MODE_CARDUPI,
            self::TRANSFER_MODE_UNKNOWN_DEFAULT_OPEN_API,
        ];
    }

    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[] $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(array $data = null)
    {
        $this->setIfExists('transfer_id', $data ?? [], null);
        $this->setIfExists('transfer_amount', $data ?? [], null);
        $this->setIfExists('transfer_currency', $data ?? [], null);
        $this->setIfExists('transfer_mode', $data ?? [], null);
        $this->setIfExists('beneficiary_details', $data ?? [], null);
        $this->setIfExists('transfer_remarks', $data ?? [], null);
        $this->setIfExists('fundsource_id', $data ?? [], null);
    }

    /**
    * Sets $this->container[$variableName] to the given data or to the given default Value; if $variableName
    * is nullable and its value is set to null in the $fields array, then mark it as "set to null" in the
    * $this->openAPINullablesSetToNull array
    *
    * @param string $variableName
    * @param array  $fields
    * @param mixed  $defaultValue
    */
    private function setIfExists(string $variableName, array $fields, $defaultValue): void
    {
        if (self::isNullable($variableName) && array_key_exists($variableName, $fields) && is_null($fields[$variableName])) {
            $this->openAPINullablesSetToNull[] = $variableName;
        }

        $this->container[$variableName] = $fields[$variableName] ?? $defaultValue;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        if ($this->container['transfer_id'] === null) {
            $invalidProperties[] = "'transfer_id' can't be null";
        }
        if ((mb_strlen($this->container['transfer_id']) > 40)) {
            $invalidProperties[] = "invalid value for 'transfer_id', the character length must be smaller than or equal to 40.";
        }

        if ($this->container['transfer_amount'] === null) {
            $invalidProperties[] = "'transfer_amount' can't be null";
        }
        $allowedValues = $this->getTransferModeAllowableValues();
        if (!is_null($this->container['transfer_mode']) && !in_array($this->container['transfer_mode'], $allowedValues, true)) {
            $invalidProperties[] = sprintf(
                "invalid value '%s' for 'transfer_mode', must be one of '%s'",
                $this->container['transfer_mode'],
                implode("', '", $allowedValues)
            );
        }

        if (!is_null($this->container['transfer_mode']) && (mb_strlen($this->container['transfer_mode']) > 20)) {
            $invalidProperties[] = "invalid value for 'transfer_mode', the character length must be smaller than or equal to 20.";
        }

        if (!is_null($this->container['transfer_remarks']) && (mb_strlen($this->container['transfer_remarks']) > 70)) {
            $invalidProperties[] = "invalid value for 'transfer_remarks', the character length must be smaller than or equal to 70.";
        }

        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets transfer_id
     *
     * @return string
     */
    public function getTransferId()
    {
        return $this->container['transfer_id'];
    }

    /**
     * Sets transfer_id
     *
     * @param string $transfer_id It is the unique ID you create to identify the transfer. You can use a maximum of 40 characters to create a transfer_id.  Alphanumeric and underscore ( _ ) are allowed.
     *
     * @return self
     */
    public function setTransferId($transfer_id)
    {
        if (is_null($transfer_id)) {
            throw new \InvalidArgumentException('non-nullable transfer_id cannot be null');
        }
        if ((mb_strlen($transfer_id) > 40)) {
            throw new \InvalidArgumentException('invalid length for $transfer_id when calling CreateBatchTransferRequestTransfersInner., must be smaller than or equal to 40.');
        }

        $this->container['transfer_id'] = $transfer_id;

        return $this;
    }

    /**
     * Gets transfer_amount
     *
     * @return float
     */
    public function getTransferAmount()
    {
        return $this->container['transfer_amount'];
    }

    /**
     * Sets transfer_amount
     *
     * @param float $transfer_amount It is the transfer amount. Decimal values are allowed. The minimum value should be equal to or greater than 1.00. (>= 1.00)
     *
     * @return self
     */
    public function setTransferAmount($transfer_amount)
    {
        if (is_null($transfer_amount)) {
            throw new \InvalidArgumentException('non-nullable transfer_amount cannot be null');
        }
        $this->container['transfer_amount'] = $transfer_amount;

        return $this;
    }

    /**
     * Gets transfer_currency
     *
     * @return string|null
     */
    public function getTransferCurrency()
    {
        return $this->container['transfer_currency'];
    }

    /**
     * Sets transfer_currency
     *
     * @param string|null $transfer_currency It is the currency of the transfer amount. The default value is INR.
     *
     * @return self
     */
    public function setTransferCurrency($transfer_currency)
    {
        if (is_null($transfer_currency)) {
            throw new \InvalidArgumentException('non-nullable transfer_currency cannot be null');
        }
        $this->container['transfer_currency'] = $transfer_currency;

        return $this;
    }

    /**
     * Gets transfer_mode
     *
     * @return string|null
     */
    public function getTransferMode()
    {
        return $this->container['transfer_mode'];
    }

    /**
     * Sets transfer_mode
     *
     * @param string|null $transfer_mode It is the mode of transfer. Allowed values are banktransfer, imps, neft, rtgs, upi, paytm, amazonpay, card. The default transfer_mode is banktransfer.
     *
     * @return self
     */
    public function setTransferMode($transfer_mode)
    {
        if (is_null($transfer_mode)) {
            throw new \InvalidArgumentException('non-nullable transfer_mode cannot be null');
        }
        $allowedValues = $this->getTransferModeAllowableValues();
        if (!in_array($transfer_mode, $allowedValues, true)) {
            throw new \InvalidArgumentException(
                sprintf(
                    "Invalid value '%s' for 'transfer_mode', must be one of '%s'",
                    $transfer_mode,
                    implode("', '", $allowedValues)
                )
            );
        }
        if ((mb_strlen($transfer_mode) > 20)) {
            throw new \InvalidArgumentException('invalid length for $transfer_mode when calling CreateBatchTransferRequestTransfersInner., must be smaller than or equal to 20.');
        }

        $this->container['transfer_mode'] = $transfer_mode;

        return $this;
    }

    /**
     * Gets beneficiary_details
     *
     * @return \Cashfree\Model\CreateBatchTransferRequestTransfersInnerBeneficiaryDetails|null
     */
    public function getBeneficiaryDetails()
    {
        return $this->container['beneficiary_details'];
    }

    /**
     * Sets beneficiary_details
     *
     * @param \Cashfree\Model\CreateBatchTransferRequestTransfersInnerBeneficiaryDetails|null $beneficiary_details beneficiary_details
     *
     * @return self
     */
    public function setBeneficiaryDetails($beneficiary_details)
    {
        if (is_null($beneficiary_details)) {
            throw new \InvalidArgumentException('non-nullable beneficiary_details cannot be null');
        }
        $this->container['beneficiary_details'] = $beneficiary_details;

        return $this;
    }

    /**
     * Gets transfer_remarks
     *
     * @return string|null
     */
    public function getTransferRemarks()
    {
        return $this->container['transfer_remarks'];
    }

    /**
     * Sets transfer_remarks
     *
     * @param string|null $transfer_remarks It can contain any additional remarks for the transfer. Alphanumeric and whitespaces are allowed. The maximum character limit is 70.
     *
     * @return self
     */
    public function setTransferRemarks($transfer_remarks)
    {
        if (is_null($transfer_remarks)) {
            throw new \InvalidArgumentException('non-nullable transfer_remarks cannot be null');
        }
        if ((mb_strlen($transfer_remarks) > 70)) {
            throw new \InvalidArgumentException('invalid length for $transfer_remarks when calling CreateBatchTransferRequestTransfersInner., must be smaller than or equal to 70.');
        }

        $this->container['transfer_remarks'] = $transfer_remarks;

        return $this;
    }

    /**
     * Gets fundsource_id
     *
     * @return string|null
     */
    public function getFundsourceId()
    {
        return $this->container['fundsource_id'];
    }

    /**
     * Sets fundsource_id
     *
     * @param string|null $fundsource_id It is the ID of the fund source from where you want to debit the transfer amount.
     *
     * @return self
     */
    public function setFundsourceId($fundsource_id)
    {
        if (is_null($fundsource_id)) {
            throw new \InvalidArgumentException('non-nullable fundsource_id cannot be null');
        }
        $this->container['fundsource_id'] = $fundsource_id;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer $offset Offset
     *
     * @return boolean
     */
    public function offsetExists($offset): bool
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer $offset Offset
     *
     * @return mixed|null
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset)
    {
        return $this->container[$offset] ?? null;
    }

    /**
     * Sets value based on offset.
     *
     * @param int|null $offset Offset
     * @param mixed    $value  Value to be set
     *
     * @return void
     */
    public function offsetSet($offset, $value): void
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer $offset Offset
     *
     * @return void
     */
    public function offsetUnset($offset): void
    {
        unset($this->container[$offset]);
    }

    /**
     * Serializes the object to a value that can be serialized natively by json_encode().
     * @link https://www.php.net/manual/en/jsonserializable.jsonserialize.php
     *
     * @return mixed Returns data which can be serialized by json_encode(), which is a value
     * of any type other than a resource.
     */
    #[\ReturnTypeWillChange]
    public function jsonSerialize()
    {
       return ObjectSerializer::sanitizeForSerialization($this);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        return json_encode(
            ObjectSerializer::sanitizeForSerialization($this),
            JSON_PRETTY_PRINT
        );
    }

    /**
     * Gets a header-safe presentation of the object
     *
     * @return string
     */
    public function toHeaderValue()
    {
        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}


