<?php
/**
 * Configuration
 * PHP version 7.4
 *
 * @category Class
 * @package  Cashfree
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * Cashfree Payout APIs
 *
 * Cashfree's Payout APIs provide developers with a streamlined pathway to integrate advanced payout capabilities into their applications, platforms and websites.
 *
 * The version of the OpenAPI document: 2024-01-01
 * Contact: developers@cashfree.com
 * Generated by: https://openapi-generator.tech
 * OpenAPI Generator version: 7.0.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace Cashfree;

use GuzzleHttp\Client;
use GuzzleHttp\Exception\ConnectException;
use GuzzleHttp\Exception\RequestException;
use GuzzleHttp\Psr7\MultipartStream;
use GuzzleHttp\Psr7\Request;
use GuzzleHttp\RequestOptions;
use Cashfree\ApiException;
use Cashfree\ObjectSerializer;
use Exception;

class PayoutWebhookEvent
{ 
    public $type;
    public $rawBody;
    public $object;
  
    // Constructor 
    public function __construct($type, $rawBody, $object){ 
        $this->type = $type;
        $this->rawBody = $rawBody;
        $this->object = $object;
    } 
}

class Cashfree {

    protected $client;
    protected $headerSelector;

    public static $XClientId = "";
    public static $XClientSecret = "";
    public static $XEnvironment = 0;
    public static $XEnableErrorAnalytics = true;
    public static $XApiVersion = "2024-01-01";

    public static $SANDBOX = 0;
    public static $PRODUCTION = 1;

    public function PayoutVerifyWebhookSignature($signature, $rawBody, $timestamp) {
        $body = $timestamp . $rawBody;
        $secretKey = Cashfree::$XClientSecret;
        $genSignature = hash_hmac('sha256', $body, $secretKey, true);
        $genSignatureBase64 = base64_encode($genSignature);
        if($genSignatureBase64 == $signature) {
            $jsonResponse = json_decode($rawBody);
            return new PayoutWebhookEvent($jsonResponse->type, $rawBody, $jsonResponse);
        }
        throw new Exception("Generated signature and received signature did not match.");
    }

    public const contentTypes = [
        'payoutCreateBeneficiary' => [
            'application/json',
        ],
        'payoutDeleteBeneficiary' => [
            'application/json',
        ],
        'payoutFetchBeneficiary' => [
            'application/json',
        ],
        'payoutFetchBatchTransfer' => [
            'application/json',
        ],
        'payoutFetchTransfer' => [
            'application/json',
        ],
        'payoutInitiateBatchTransfer' => [
            'application/json',
        ],
        'payoutInitiateTransfer' => [
            'application/json',
        ],
    ];



    public function PayoutCreateBeneficiary($x_api_version, $x_request_id = null, $create_beneficiary_request = null, GuzzleHttp\Client $http_client = null)
    {

        $env = "sandbox";
        if(Cashfree::$XEnvironment == Cashfree::$PRODUCTION) {
            $env = "production";
        }
        if(Cashfree::$XEnableErrorAnalytics) {
            \Sentry\init([
                'dsn' => 'https://22dc3de52807f3d61e5f581c2005d7b0@o330525.ingest.us.sentry.io/4506869802008576',
                'environment' => $env."PayoutCreateBeneficiary",
                'attach_stacktrace' => true,
                'release' => '0.0.11',
                'traces_sample_rate' => 1.0,
                'before_send' => function (\Sentry\Event $event): ?\Sentry\Event {
                    $cashfreepayout = "cashfree-payout";
                    if (count($event->getExceptions()) > 0 && count($event->getExceptions()[0]->getStackTrace()->getFrames()) > 0) {
                    if (strpos($event->getExceptions()[0]->getStackTrace()->getFrames()[0]->getFile(), $cashfreepayout) !== false) {
                        $osContext = $event->getOsContext();
                        $osContext->setKernelVersion("");
                        $osContext->setMachineType("");
                        $osContext->setKernelVersion("");
                        $osContext->setVersion("");
                        $event->setOsContext($osContext);
                        if(Cashfree::$XEnableErrorAnalytics) {
                            return $event;
                        }
                        return null;
                    }
                    }
                return null;
                },
            ]);
        }

        $this->client = new Client();
        if($http_client !== null) {
            $this->client = $http_client;
        }
        $this->headerSelector = new HeaderSelector();
        $contentType = self::contentTypes['payoutCreateBeneficiary'][0];
        $request = $this->payoutCreateBeneficiaryRequest($x_api_version, $x_request_id, $create_beneficiary_request, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch($statusCode) {
                case 201:
                    if ('\Cashfree\Model\Beneficiary' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Cashfree\Model\Beneficiary' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Cashfree\Model\Beneficiary', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 400:
                    if ('\Cashfree\Model\ErrorV2' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Cashfree\Model\ErrorV2' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Cashfree\Model\ErrorV2', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 403:
                    if ('\Cashfree\Model\ErrorV2' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Cashfree\Model\ErrorV2' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Cashfree\Model\ErrorV2', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 409:
                    if ('\Cashfree\Model\ErrorV2' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Cashfree\Model\ErrorV2' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Cashfree\Model\ErrorV2', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 422:
                    if ('\Cashfree\Model\ErrorV2' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Cashfree\Model\ErrorV2' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Cashfree\Model\ErrorV2', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\Cashfree\Model\Beneficiary';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    $content = json_decode($content);
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 201:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Cashfree\Model\Beneficiary',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Cashfree\Model\ErrorV2',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Cashfree\Model\ErrorV2',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 409:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Cashfree\Model\ErrorV2',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 422:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Cashfree\Model\ErrorV2',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    public function payoutCreateBeneficiaryRequest($x_api_version, $x_request_id = null, $create_beneficiary_request = null, string $contentType = self::contentTypes['payoutCreateBeneficiary'][0])
    {

        // verify the required parameter 'x_api_version' is set
        if ($x_api_version === null || (is_array($x_api_version) && count($x_api_version) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $x_api_version when calling payoutCreateBeneficiary'
            );
        }




        $resourcePath = '/beneficiary';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;


        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        $headers['x-sdk-platform'] = "phpsdk-0.0.11";

        if (Cashfree::$XClientSecret !== null) {
            $headers['x-client-secret'] = Cashfree::$XClientSecret;
        }


        if (Cashfree::$XClientId !== null) {
            $headers['x-client-id'] = Cashfree::$XClientId;
        }

        $headers['x-api-version'] = $x_api_version;
        if($x_request_id !== null) {
            $headers['x-request-id'] = $x_request_id;
        }



        // for model (json/xml)
        if (isset($create_beneficiary_request)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($create_beneficiary_request));
            } else {
                $httpBody = $create_beneficiary_request;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        $defaultHeaders = [];

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = "https://sandbox.cashfree.com/payout";
        if(Cashfree::$XEnvironment == Cashfree::$PRODUCTION) {
            $operationHost = "https://api.cashfree.com/payout";
        }
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'POST',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }


    public function PayoutDeleteBeneficiary($x_api_version, $x_request_id = null, $beneficiary_id = null, GuzzleHttp\Client $http_client = null)
    {

        $env = "sandbox";
        if(Cashfree::$XEnvironment == Cashfree::$PRODUCTION) {
            $env = "production";
        }
        if(Cashfree::$XEnableErrorAnalytics) {
            \Sentry\init([
                'dsn' => 'https://22dc3de52807f3d61e5f581c2005d7b0@o330525.ingest.us.sentry.io/4506869802008576',
                'environment' => $env."PayoutDeleteBeneficiary",
                'attach_stacktrace' => true,
                'release' => '0.0.11',
                'traces_sample_rate' => 1.0,
                'before_send' => function (\Sentry\Event $event): ?\Sentry\Event {
                    $cashfreepayout = "cashfree-payout";
                    if (count($event->getExceptions()) > 0 && count($event->getExceptions()[0]->getStackTrace()->getFrames()) > 0) {
                    if (strpos($event->getExceptions()[0]->getStackTrace()->getFrames()[0]->getFile(), $cashfreepayout) !== false) {
                        $osContext = $event->getOsContext();
                        $osContext->setKernelVersion("");
                        $osContext->setMachineType("");
                        $osContext->setKernelVersion("");
                        $osContext->setVersion("");
                        $event->setOsContext($osContext);
                        if(Cashfree::$XEnableErrorAnalytics) {
                            return $event;
                        }
                        return null;
                    }
                    }
                return null;
                },
            ]);
        }

        $this->client = new Client();
        if($http_client !== null) {
            $this->client = $http_client;
        }
        $this->headerSelector = new HeaderSelector();
        $contentType = self::contentTypes['payoutDeleteBeneficiary'][0];
        $request = $this->payoutDeleteBeneficiaryRequest($x_api_version, $x_request_id, $beneficiary_id, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch($statusCode) {
                case 200:
                    if ('\Cashfree\Model\Beneficiary' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Cashfree\Model\Beneficiary' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Cashfree\Model\Beneficiary', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 400:
                    if ('\Cashfree\Model\ErrorV2' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Cashfree\Model\ErrorV2' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Cashfree\Model\ErrorV2', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 403:
                    if ('\Cashfree\Model\ErrorV2' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Cashfree\Model\ErrorV2' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Cashfree\Model\ErrorV2', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 404:
                    if ('\Cashfree\Model\ErrorV2' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Cashfree\Model\ErrorV2' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Cashfree\Model\ErrorV2', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 500:
                    if ('\Cashfree\Model\ErrorV2' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Cashfree\Model\ErrorV2' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Cashfree\Model\ErrorV2', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\Cashfree\Model\Beneficiary';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    $content = json_decode($content);
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Cashfree\Model\Beneficiary',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Cashfree\Model\ErrorV2',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Cashfree\Model\ErrorV2',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Cashfree\Model\ErrorV2',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Cashfree\Model\ErrorV2',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    public function payoutDeleteBeneficiaryRequest($x_api_version, $x_request_id = null, $beneficiary_id = null, string $contentType = self::contentTypes['payoutDeleteBeneficiary'][0])
    {

        // verify the required parameter 'x_api_version' is set
        if ($x_api_version === null || (is_array($x_api_version) && count($x_api_version) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $x_api_version when calling payoutDeleteBeneficiary'
            );
        }


        if ($beneficiary_id !== null && strlen($beneficiary_id) > 50) {
            throw new \InvalidArgumentException('invalid length for "$beneficiary_id" when calling BeneficiaryV2Api.payoutDeleteBeneficiary, must be smaller than or equal to 50.');
        }
        

        $resourcePath = '/beneficiary';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $beneficiary_id,
            'beneficiary_id', // param base name
            'string', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);

        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        $headers['x-sdk-platform'] = "phpsdk-0.0.11";

        if (Cashfree::$XClientSecret !== null) {
            $headers['x-client-secret'] = Cashfree::$XClientSecret;
        }


        if (Cashfree::$XClientId !== null) {
            $headers['x-client-id'] = Cashfree::$XClientId;
        }

        $headers['x-api-version'] = $x_api_version;
        if($x_request_id !== null) {
            $headers['x-request-id'] = $x_request_id;
        }



        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        $defaultHeaders = [];

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = "https://sandbox.cashfree.com/payout";
        if(Cashfree::$XEnvironment == Cashfree::$PRODUCTION) {
            $operationHost = "https://api.cashfree.com/payout";
        }
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'DELETE',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }


    public function PayoutFetchBeneficiary($x_api_version, $x_request_id = null, $beneficiary_id = null, $bank_account_number = null, $bank_ifsc = null, GuzzleHttp\Client $http_client = null)
    {

        $env = "sandbox";
        if(Cashfree::$XEnvironment == Cashfree::$PRODUCTION) {
            $env = "production";
        }
        if(Cashfree::$XEnableErrorAnalytics) {
            \Sentry\init([
                'dsn' => 'https://22dc3de52807f3d61e5f581c2005d7b0@o330525.ingest.us.sentry.io/4506869802008576',
                'environment' => $env."PayoutFetchBeneficiary",
                'attach_stacktrace' => true,
                'release' => '0.0.11',
                'traces_sample_rate' => 1.0,
                'before_send' => function (\Sentry\Event $event): ?\Sentry\Event {
                    $cashfreepayout = "cashfree-payout";
                    if (count($event->getExceptions()) > 0 && count($event->getExceptions()[0]->getStackTrace()->getFrames()) > 0) {
                    if (strpos($event->getExceptions()[0]->getStackTrace()->getFrames()[0]->getFile(), $cashfreepayout) !== false) {
                        $osContext = $event->getOsContext();
                        $osContext->setKernelVersion("");
                        $osContext->setMachineType("");
                        $osContext->setKernelVersion("");
                        $osContext->setVersion("");
                        $event->setOsContext($osContext);
                        if(Cashfree::$XEnableErrorAnalytics) {
                            return $event;
                        }
                        return null;
                    }
                    }
                return null;
                },
            ]);
        }

        $this->client = new Client();
        if($http_client !== null) {
            $this->client = $http_client;
        }
        $this->headerSelector = new HeaderSelector();
        $contentType = self::contentTypes['payoutFetchBeneficiary'][0];
        $request = $this->payoutFetchBeneficiaryRequest($x_api_version, $x_request_id, $beneficiary_id, $bank_account_number, $bank_ifsc, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch($statusCode) {
                case 200:
                    if ('\Cashfree\Model\Beneficiary' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Cashfree\Model\Beneficiary' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Cashfree\Model\Beneficiary', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 400:
                    if ('\Cashfree\Model\ErrorV2' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Cashfree\Model\ErrorV2' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Cashfree\Model\ErrorV2', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 403:
                    if ('\Cashfree\Model\ErrorV2' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Cashfree\Model\ErrorV2' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Cashfree\Model\ErrorV2', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 404:
                    if ('\Cashfree\Model\ErrorV2' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Cashfree\Model\ErrorV2' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Cashfree\Model\ErrorV2', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 500:
                    if ('\Cashfree\Model\ErrorV2' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Cashfree\Model\ErrorV2' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Cashfree\Model\ErrorV2', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\Cashfree\Model\Beneficiary';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    $content = json_decode($content);
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Cashfree\Model\Beneficiary',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Cashfree\Model\ErrorV2',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Cashfree\Model\ErrorV2',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Cashfree\Model\ErrorV2',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Cashfree\Model\ErrorV2',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    public function payoutFetchBeneficiaryRequest($x_api_version, $x_request_id = null, $beneficiary_id = null, $bank_account_number = null, $bank_ifsc = null, string $contentType = self::contentTypes['payoutFetchBeneficiary'][0])
    {

        // verify the required parameter 'x_api_version' is set
        if ($x_api_version === null || (is_array($x_api_version) && count($x_api_version) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $x_api_version when calling payoutFetchBeneficiary'
            );
        }


        if ($beneficiary_id !== null && strlen($beneficiary_id) > 50) {
            throw new \InvalidArgumentException('invalid length for "$beneficiary_id" when calling BeneficiaryV2Api.payoutFetchBeneficiary, must be smaller than or equal to 50.');
        }
        
        if ($bank_account_number !== null && strlen($bank_account_number) > 25) {
            throw new \InvalidArgumentException('invalid length for "$bank_account_number" when calling BeneficiaryV2Api.payoutFetchBeneficiary, must be smaller than or equal to 25.');
        }
        if ($bank_account_number !== null && strlen($bank_account_number) < 4) {
            throw new \InvalidArgumentException('invalid length for "$bank_account_number" when calling BeneficiaryV2Api.payoutFetchBeneficiary, must be bigger than or equal to 4.');
        }
        
        if ($bank_ifsc !== null && strlen($bank_ifsc) > 11) {
            throw new \InvalidArgumentException('invalid length for "$bank_ifsc" when calling BeneficiaryV2Api.payoutFetchBeneficiary, must be smaller than or equal to 11.');
        }
        if ($bank_ifsc !== null && strlen($bank_ifsc) < 11) {
            throw new \InvalidArgumentException('invalid length for "$bank_ifsc" when calling BeneficiaryV2Api.payoutFetchBeneficiary, must be bigger than or equal to 11.');
        }
        

        $resourcePath = '/beneficiary';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $beneficiary_id,
            'beneficiary_id', // param base name
            'string', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $bank_account_number,
            'bank_account_number', // param base name
            'string', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $bank_ifsc,
            'bank_ifsc', // param base name
            'string', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);

        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        $headers['x-sdk-platform'] = "phpsdk-0.0.11";

        if (Cashfree::$XClientSecret !== null) {
            $headers['x-client-secret'] = Cashfree::$XClientSecret;
        }


        if (Cashfree::$XClientId !== null) {
            $headers['x-client-id'] = Cashfree::$XClientId;
        }

        $headers['x-api-version'] = $x_api_version;
        if($x_request_id !== null) {
            $headers['x-request-id'] = $x_request_id;
        }



        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        $defaultHeaders = [];

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = "https://sandbox.cashfree.com/payout";
        if(Cashfree::$XEnvironment == Cashfree::$PRODUCTION) {
            $operationHost = "https://api.cashfree.com/payout";
        }
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }


    public function PayoutFetchBatchTransfer($x_api_version, $x_request_id = null, $cf_batch_transfer_id = null, $batch_transfer_id = null, GuzzleHttp\Client $http_client = null)
    {

        $env = "sandbox";
        if(Cashfree::$XEnvironment == Cashfree::$PRODUCTION) {
            $env = "production";
        }
        if(Cashfree::$XEnableErrorAnalytics) {
            \Sentry\init([
                'dsn' => 'https://22dc3de52807f3d61e5f581c2005d7b0@o330525.ingest.us.sentry.io/4506869802008576',
                'environment' => $env."PayoutFetchBatchTransfer",
                'attach_stacktrace' => true,
                'release' => '0.0.11',
                'traces_sample_rate' => 1.0,
                'before_send' => function (\Sentry\Event $event): ?\Sentry\Event {
                    $cashfreepayout = "cashfree-payout";
                    if (count($event->getExceptions()) > 0 && count($event->getExceptions()[0]->getStackTrace()->getFrames()) > 0) {
                    if (strpos($event->getExceptions()[0]->getStackTrace()->getFrames()[0]->getFile(), $cashfreepayout) !== false) {
                        $osContext = $event->getOsContext();
                        $osContext->setKernelVersion("");
                        $osContext->setMachineType("");
                        $osContext->setKernelVersion("");
                        $osContext->setVersion("");
                        $event->setOsContext($osContext);
                        if(Cashfree::$XEnableErrorAnalytics) {
                            return $event;
                        }
                        return null;
                    }
                    }
                return null;
                },
            ]);
        }

        $this->client = new Client();
        if($http_client !== null) {
            $this->client = $http_client;
        }
        $this->headerSelector = new HeaderSelector();
        $contentType = self::contentTypes['payoutFetchBatchTransfer'][0];
        $request = $this->payoutFetchBatchTransferRequest($x_api_version, $x_request_id, $cf_batch_transfer_id, $batch_transfer_id, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch($statusCode) {
                case 200:
                    if ('\Cashfree\Model\FetchBatchTransferResponse' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Cashfree\Model\FetchBatchTransferResponse' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Cashfree\Model\FetchBatchTransferResponse', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 404:
                    if ('\Cashfree\Model\ErrorV2' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Cashfree\Model\ErrorV2' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Cashfree\Model\ErrorV2', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 500:
                    if ('\Cashfree\Model\ErrorV2' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Cashfree\Model\ErrorV2' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Cashfree\Model\ErrorV2', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\Cashfree\Model\FetchBatchTransferResponse';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    $content = json_decode($content);
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Cashfree\Model\FetchBatchTransferResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Cashfree\Model\ErrorV2',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Cashfree\Model\ErrorV2',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    public function payoutFetchBatchTransferRequest($x_api_version, $x_request_id = null, $cf_batch_transfer_id = null, $batch_transfer_id = null, string $contentType = self::contentTypes['payoutFetchBatchTransfer'][0])
    {

        // verify the required parameter 'x_api_version' is set
        if ($x_api_version === null || (is_array($x_api_version) && count($x_api_version) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $x_api_version when calling payoutFetchBatchTransfer'
            );
        }





        $resourcePath = '/transfers/batch';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $cf_batch_transfer_id,
            'cf_batch_transfer_id', // param base name
            'string', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $batch_transfer_id,
            'batch_transfer_id', // param base name
            'string', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);

        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        $headers['x-sdk-platform'] = "phpsdk-0.0.11";

        if (Cashfree::$XClientSecret !== null) {
            $headers['x-client-secret'] = Cashfree::$XClientSecret;
        }


        if (Cashfree::$XClientId !== null) {
            $headers['x-client-id'] = Cashfree::$XClientId;
        }

        $headers['x-api-version'] = $x_api_version;
        if($x_request_id !== null) {
            $headers['x-request-id'] = $x_request_id;
        }



        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        $defaultHeaders = [];

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = "https://sandbox.cashfree.com/payout";
        if(Cashfree::$XEnvironment == Cashfree::$PRODUCTION) {
            $operationHost = "https://api.cashfree.com/payout";
        }
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }


    public function PayoutFetchTransfer($x_api_version, $x_request_id = null, $cf_transfer_id = null, $transfer_id = null, GuzzleHttp\Client $http_client = null)
    {

        $env = "sandbox";
        if(Cashfree::$XEnvironment == Cashfree::$PRODUCTION) {
            $env = "production";
        }
        if(Cashfree::$XEnableErrorAnalytics) {
            \Sentry\init([
                'dsn' => 'https://22dc3de52807f3d61e5f581c2005d7b0@o330525.ingest.us.sentry.io/4506869802008576',
                'environment' => $env."PayoutFetchTransfer",
                'attach_stacktrace' => true,
                'release' => '0.0.11',
                'traces_sample_rate' => 1.0,
                'before_send' => function (\Sentry\Event $event): ?\Sentry\Event {
                    $cashfreepayout = "cashfree-payout";
                    if (count($event->getExceptions()) > 0 && count($event->getExceptions()[0]->getStackTrace()->getFrames()) > 0) {
                    if (strpos($event->getExceptions()[0]->getStackTrace()->getFrames()[0]->getFile(), $cashfreepayout) !== false) {
                        $osContext = $event->getOsContext();
                        $osContext->setKernelVersion("");
                        $osContext->setMachineType("");
                        $osContext->setKernelVersion("");
                        $osContext->setVersion("");
                        $event->setOsContext($osContext);
                        if(Cashfree::$XEnableErrorAnalytics) {
                            return $event;
                        }
                        return null;
                    }
                    }
                return null;
                },
            ]);
        }

        $this->client = new Client();
        if($http_client !== null) {
            $this->client = $http_client;
        }
        $this->headerSelector = new HeaderSelector();
        $contentType = self::contentTypes['payoutFetchTransfer'][0];
        $request = $this->payoutFetchTransferRequest($x_api_version, $x_request_id, $cf_transfer_id, $transfer_id, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch($statusCode) {
                case 200:
                    if ('\Cashfree\Model\CreateTransferResponse' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Cashfree\Model\CreateTransferResponse' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Cashfree\Model\CreateTransferResponse', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 403:
                    if ('\Cashfree\Model\ErrorV2' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Cashfree\Model\ErrorV2' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Cashfree\Model\ErrorV2', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 404:
                    if ('\Cashfree\Model\ErrorV2' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Cashfree\Model\ErrorV2' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Cashfree\Model\ErrorV2', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 500:
                    if ('\Cashfree\Model\ErrorV2' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Cashfree\Model\ErrorV2' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Cashfree\Model\ErrorV2', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\Cashfree\Model\CreateTransferResponse';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    $content = json_decode($content);
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Cashfree\Model\CreateTransferResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Cashfree\Model\ErrorV2',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Cashfree\Model\ErrorV2',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Cashfree\Model\ErrorV2',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    public function payoutFetchTransferRequest($x_api_version, $x_request_id = null, $cf_transfer_id = null, $transfer_id = null, string $contentType = self::contentTypes['payoutFetchTransfer'][0])
    {

        // verify the required parameter 'x_api_version' is set
        if ($x_api_version === null || (is_array($x_api_version) && count($x_api_version) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $x_api_version when calling payoutFetchTransfer'
            );
        }





        $resourcePath = '/transfers';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $cf_transfer_id,
            'cf_transfer_id', // param base name
            'string', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $transfer_id,
            'transfer_id', // param base name
            'string', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);

        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        $headers['x-sdk-platform'] = "phpsdk-0.0.11";

        if (Cashfree::$XClientSecret !== null) {
            $headers['x-client-secret'] = Cashfree::$XClientSecret;
        }


        if (Cashfree::$XClientId !== null) {
            $headers['x-client-id'] = Cashfree::$XClientId;
        }

        $headers['x-api-version'] = $x_api_version;
        if($x_request_id !== null) {
            $headers['x-request-id'] = $x_request_id;
        }



        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        $defaultHeaders = [];

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = "https://sandbox.cashfree.com/payout";
        if(Cashfree::$XEnvironment == Cashfree::$PRODUCTION) {
            $operationHost = "https://api.cashfree.com/payout";
        }
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }


    public function PayoutInitiateBatchTransfer($x_api_version, $x_request_id = null, $create_batch_transfer_request = null, GuzzleHttp\Client $http_client = null)
    {

        $env = "sandbox";
        if(Cashfree::$XEnvironment == Cashfree::$PRODUCTION) {
            $env = "production";
        }
        if(Cashfree::$XEnableErrorAnalytics) {
            \Sentry\init([
                'dsn' => 'https://22dc3de52807f3d61e5f581c2005d7b0@o330525.ingest.us.sentry.io/4506869802008576',
                'environment' => $env."PayoutInitiateBatchTransfer",
                'attach_stacktrace' => true,
                'release' => '0.0.11',
                'traces_sample_rate' => 1.0,
                'before_send' => function (\Sentry\Event $event): ?\Sentry\Event {
                    $cashfreepayout = "cashfree-payout";
                    if (count($event->getExceptions()) > 0 && count($event->getExceptions()[0]->getStackTrace()->getFrames()) > 0) {
                    if (strpos($event->getExceptions()[0]->getStackTrace()->getFrames()[0]->getFile(), $cashfreepayout) !== false) {
                        $osContext = $event->getOsContext();
                        $osContext->setKernelVersion("");
                        $osContext->setMachineType("");
                        $osContext->setKernelVersion("");
                        $osContext->setVersion("");
                        $event->setOsContext($osContext);
                        if(Cashfree::$XEnableErrorAnalytics) {
                            return $event;
                        }
                        return null;
                    }
                    }
                return null;
                },
            ]);
        }

        $this->client = new Client();
        if($http_client !== null) {
            $this->client = $http_client;
        }
        $this->headerSelector = new HeaderSelector();
        $contentType = self::contentTypes['payoutInitiateBatchTransfer'][0];
        $request = $this->payoutInitiateBatchTransferRequest($x_api_version, $x_request_id, $create_batch_transfer_request, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch($statusCode) {
                case 200:
                    if ('\Cashfree\Model\CreateBatchTransferResponse' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Cashfree\Model\CreateBatchTransferResponse' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Cashfree\Model\CreateBatchTransferResponse', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 400:
                    if ('\Cashfree\Model\ErrorV2' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Cashfree\Model\ErrorV2' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Cashfree\Model\ErrorV2', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 409:
                    if ('\Cashfree\Model\ErrorV2' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Cashfree\Model\ErrorV2' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Cashfree\Model\ErrorV2', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 500:
                    if ('\Cashfree\Model\ErrorV2' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Cashfree\Model\ErrorV2' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Cashfree\Model\ErrorV2', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\Cashfree\Model\CreateBatchTransferResponse';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    $content = json_decode($content);
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Cashfree\Model\CreateBatchTransferResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Cashfree\Model\ErrorV2',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 409:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Cashfree\Model\ErrorV2',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Cashfree\Model\ErrorV2',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    public function payoutInitiateBatchTransferRequest($x_api_version, $x_request_id = null, $create_batch_transfer_request = null, string $contentType = self::contentTypes['payoutInitiateBatchTransfer'][0])
    {

        // verify the required parameter 'x_api_version' is set
        if ($x_api_version === null || (is_array($x_api_version) && count($x_api_version) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $x_api_version when calling payoutInitiateBatchTransfer'
            );
        }




        $resourcePath = '/transfers/batch';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;


        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        $headers['x-sdk-platform'] = "phpsdk-0.0.11";

        if (Cashfree::$XClientSecret !== null) {
            $headers['x-client-secret'] = Cashfree::$XClientSecret;
        }


        if (Cashfree::$XClientId !== null) {
            $headers['x-client-id'] = Cashfree::$XClientId;
        }

        $headers['x-api-version'] = $x_api_version;
        if($x_request_id !== null) {
            $headers['x-request-id'] = $x_request_id;
        }



        // for model (json/xml)
        if (isset($create_batch_transfer_request)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($create_batch_transfer_request));
            } else {
                $httpBody = $create_batch_transfer_request;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        $defaultHeaders = [];

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = "https://sandbox.cashfree.com/payout";
        if(Cashfree::$XEnvironment == Cashfree::$PRODUCTION) {
            $operationHost = "https://api.cashfree.com/payout";
        }
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'POST',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }


    public function PayoutInitiateTransfer($x_api_version, $x_request_id = null, $create_transfer_request = null, GuzzleHttp\Client $http_client = null)
    {

        $env = "sandbox";
        if(Cashfree::$XEnvironment == Cashfree::$PRODUCTION) {
            $env = "production";
        }
        if(Cashfree::$XEnableErrorAnalytics) {
            \Sentry\init([
                'dsn' => 'https://22dc3de52807f3d61e5f581c2005d7b0@o330525.ingest.us.sentry.io/4506869802008576',
                'environment' => $env."PayoutInitiateTransfer",
                'attach_stacktrace' => true,
                'release' => '0.0.11',
                'traces_sample_rate' => 1.0,
                'before_send' => function (\Sentry\Event $event): ?\Sentry\Event {
                    $cashfreepayout = "cashfree-payout";
                    if (count($event->getExceptions()) > 0 && count($event->getExceptions()[0]->getStackTrace()->getFrames()) > 0) {
                    if (strpos($event->getExceptions()[0]->getStackTrace()->getFrames()[0]->getFile(), $cashfreepayout) !== false) {
                        $osContext = $event->getOsContext();
                        $osContext->setKernelVersion("");
                        $osContext->setMachineType("");
                        $osContext->setKernelVersion("");
                        $osContext->setVersion("");
                        $event->setOsContext($osContext);
                        if(Cashfree::$XEnableErrorAnalytics) {
                            return $event;
                        }
                        return null;
                    }
                    }
                return null;
                },
            ]);
        }

        $this->client = new Client();
        if($http_client !== null) {
            $this->client = $http_client;
        }
        $this->headerSelector = new HeaderSelector();
        $contentType = self::contentTypes['payoutInitiateTransfer'][0];
        $request = $this->payoutInitiateTransferRequest($x_api_version, $x_request_id, $create_transfer_request, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch($statusCode) {
                case 200:
                    if ('\Cashfree\Model\CreateTransferResponse' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Cashfree\Model\CreateTransferResponse' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Cashfree\Model\CreateTransferResponse', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 400:
                    if ('\Cashfree\Model\ErrorV2' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Cashfree\Model\ErrorV2' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Cashfree\Model\ErrorV2', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 403:
                    if ('\Cashfree\Model\ErrorV2' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Cashfree\Model\ErrorV2' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Cashfree\Model\ErrorV2', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 404:
                    if ('\Cashfree\Model\ErrorV2' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Cashfree\Model\ErrorV2' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Cashfree\Model\ErrorV2', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 500:
                    if ('\Cashfree\Model\ErrorV2' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Cashfree\Model\ErrorV2' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Cashfree\Model\ErrorV2', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\Cashfree\Model\CreateTransferResponse';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    $content = json_decode($content);
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Cashfree\Model\CreateTransferResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Cashfree\Model\ErrorV2',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Cashfree\Model\ErrorV2',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Cashfree\Model\ErrorV2',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Cashfree\Model\ErrorV2',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    public function payoutInitiateTransferRequest($x_api_version, $x_request_id = null, $create_transfer_request = null, string $contentType = self::contentTypes['payoutInitiateTransfer'][0])
    {

        // verify the required parameter 'x_api_version' is set
        if ($x_api_version === null || (is_array($x_api_version) && count($x_api_version) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $x_api_version when calling payoutInitiateTransfer'
            );
        }




        $resourcePath = '/transfers';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;


        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        $headers['x-sdk-platform'] = "phpsdk-0.0.11";

        if (Cashfree::$XClientSecret !== null) {
            $headers['x-client-secret'] = Cashfree::$XClientSecret;
        }


        if (Cashfree::$XClientId !== null) {
            $headers['x-client-id'] = Cashfree::$XClientId;
        }

        $headers['x-api-version'] = $x_api_version;
        if($x_request_id !== null) {
            $headers['x-request-id'] = $x_request_id;
        }



        // for model (json/xml)
        if (isset($create_transfer_request)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($create_transfer_request));
            } else {
                $httpBody = $create_transfer_request;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        $defaultHeaders = [];

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = "https://sandbox.cashfree.com/payout";
        if(Cashfree::$XEnvironment == Cashfree::$PRODUCTION) {
            $operationHost = "https://api.cashfree.com/payout";
        }
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'POST',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }


    protected function createHttpClientOption()
    {
        $options = [];

        return $options;
    }
}
