<?php $__env->startSection('title', 'Users'); ?>

<?php $__env->startSection('content'); ?>

    <section class="content">
        <div class="row">
            <div class="col-12">
                <div class="box table-responsive">
                    <div class="box-header with-border">
                        <div class="row text-right">
                            
                            <?php if(auth()->user()->can('add-country')): ?>
                            <div class="col-12 text-right">
                                <a href="<?php echo e(url('country/create')); ?>" class="btn btn-primary btn-sm">
                                    <i class="mdi mdi-plus-circle mr-2"></i><?php echo app('translator')->get('view_pages.add_country'); ?></a>
                            </div>
                            <?php endif; ?>
                        </div>
                    </div>

                    <div id="js-country-partial-target">
                        <include-fragment src="country/fetch">
                            <span style="text-align: center;font-weight: bold;"><?php echo app('translator')->get('view_pages.loading'); ?></span>
                        </include-fragment>
                    </div>

                </div>
            </div>
        </div>

        <script src="<?php echo e(asset('assets/js/fetchdata.min.js')); ?>"></script>
        <script>
            $(function() {
                $('body').on('click', '.pagination a', function(e) {
                    e.preventDefault();
                    var url = $(this).attr('href');
                    $.get(url, $('#search').serialize(), function(data) {
                        $('#js-country-partial-target').html(data);
                    });
                });

                $('#search').on('click', function(e) {
                    e.preventDefault();
                    var search_keyword = $('#search_keyword').val();
                    console.log(search_keyword);
                    fetch('country/fetch?search=' + search_keyword)
                        .then(response => response.text())
                        .then(html => {
                            document.querySelector('#js-country-partial-target').innerHTML = html
                        });
                });

            });

            $(document).on('click', '.countryToggle', function(e) {
                e.preventDefault();

                let url = $(this).attr('data-url');

                $.ajax({
                    url: url,
                    cache: false,
                    success: function(res) {

                        fetch('country/fetch?')
                            .then(response => response.text())
                            .then(html => {
                                document.querySelector('#js-country-partial-target')
                                    .innerHTML = html
                            });

                        $.toast({
                            heading: '',
                            text: res,
                            position: 'top-right',
                            loaderBg: '#ff6849',
                            icon: 'success',
                            hideAfter: 5000,
                            stack: 1
                        });
                    }
                });
            });
            $(document).on('click', '.sweet-delete', function(e) {
                e.preventDefault();

                let url = $(this).attr('data-url');

                swal({
                    title: "Are you sure to delete ?",
                    type: "error",
                    showCancelButton: true,
                    confirmButtonColor: "#DD6B55",
                    confirmButtonText: "Delete",
                    cancelButtonText: "No! Keep it",
                    closeOnConfirm: false,
                    closeOnCancel: true
                }, function(isConfirm) {
                    if (isConfirm) {
                        swal.close();

                        $.ajax({
                            url: url,
                            cache: false,
                            success: function(res) {

                                fetch('country/fetch?')
                                    .then(response => response.text())
                                    .then(html => {
                                        document.querySelector('#js-country-partial-target')
                                            .innerHTML = html
                                    });

                                $.toast({
                                    heading: '',
                                    text: res,
                                    position: 'top-right',
                                    loaderBg: '#ff6849',
                                    icon: 'success',
                                    hideAfter: 5000,
                                    stack: 1
                                });
                            }
                        });
                    }
                });
            });

        </script>
    <?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\Users\khaled\Desktop\Main-File-April-09\server-app-April-9\resources\views/admin/country/index.blade.php ENDPATH**/ ?>