
<?php

$app_for = config('app.app_for');

if(str_contains((string)request()->path(),'translations')){
  $main_menu = 'settings';
  $sub_menu = 'translations';
}
?>
<aside class="main-sidebar">
  <!-- sidebar-->
  <section class="sidebar">
    <!-- sidebar menu-->
    <ul class="sidebar-menu" data-widget="tree">
      <?php if(auth()->user()->can('access-dashboard')): ?>
      <li class="<?php echo e('dashboard' == $main_menu ? 'active' : ''); ?>">
        <a href="<?php echo e(url('/dashboard')); ?>">
          <i class="fa fa-tachometer"></i> <span><?php echo app('translator')->get('pages_names.dashboard'); ?></span>
        </a>
      </li>
      <?php endif; ?>

       <?php if(auth()->user()->can('view-settings')): ?>
      <li class="treeview <?php echo e('settings' == $main_menu ? 'active menu-open' : ''); ?>">
        <a href="javascript: void(0);">
          <i class="fa fa-cogs"></i>
          <span> <?php echo app('translator')->get('pages_names.settings'); ?> </span>
          <span class="pull-right-container">
            <i class="fa fa-angle-right pull-right"></i>
          </span>
        </a>

        <ul class="treeview-menu">
          <?php if(auth()->user()->can('view-roles')): ?>
          <li class="<?php echo e('roles' == $sub_menu ? 'active' : ''); ?>">
            <a href="<?php echo e(url('/roles')); ?>"><i class="fa fa-circle-thin"></i><?php echo app('translator')->get('pages_names.roles'); ?></a>
          </li>
          <?php endif; ?>
          <?php if(auth()->user()->can('view-system-settings')): ?>
          <li class="<?php echo e('system_settings' == $sub_menu ? 'active' : ''); ?>">
            <a href="<?php echo e(url('/system/settings')); ?>"><i class="fa fa-circle-thin"></i><?php echo app('translator')->get('pages_names.system_settings'); ?></a>
          </li>
          <?php endif; ?>
          <?php if(auth()->user()->can('map-settings')): ?>
          <li class="<?php echo e('translations' == $sub_menu ? 'active' : ''); ?>">
            <a href="<?php echo e(url('/system/settings/map')); ?>"><i class="fa fa-circle-thin"></i><?php echo app('translator')->get('pages_names.map_settings'); ?></a>
          </li>
          <?php endif; ?>
          <?php if(auth()->user()->can('sms-settings')): ?>
          <li class="<?php echo e('translations' == $sub_menu ? 'active' : ''); ?>">
            <a href="<?php echo e(url('/system/settings/sms_gateway')); ?>"><i class="fa fa-circle-thin"></i><?php echo app('translator')->get('pages_names.sms_settings'); ?></a>
          </li>
          <?php endif; ?>
          <?php if(auth()->user()->can('view-translations')): ?>
          <li class="<?php echo e('translations' == $sub_menu ? 'active' : ''); ?>">
            <a href="<?php echo e(url('/translations')); ?>"><i class="fa fa-circle-thin"></i><?php echo app('translator')->get('pages_names.translations'); ?></a>
          </li>
          <?php endif; ?>

          <?php if(auth()->user()->can('onboarding-screen')): ?>
          <li class="<?php echo e('onboarding' == $sub_menu ? 'active' : ''); ?>">
            <a href="<?php echo e(url('/system/settings/onboarding')); ?>"><i class="fa fa-circle-thin"></i><?php echo app('translator')->get('pages_names.onboarding_screen'); ?></a>
          </li>
          <?php endif; ?>  
          <?php if(auth()->user()->can('invoicecms')): ?>
          <li class="<?php echo e('cms_invoice' == $sub_menu ? 'active' : ''); ?>">
            <a href="<?php echo e(url('/cms/invoicecms')); ?>"><i class="fa fa-circle-thin"></i><?php echo app('translator')->get('pages_names.invoice_cms'); ?></a>
          </li>
          <?php endif; ?>
          <?php if(auth()->user()->can('manage-country')): ?>
          <li class="<?php echo e('country' == $sub_menu ? 'active' : ''); ?>">
            <a href="<?php echo e(url('/country')); ?>"><i class="fa fa-circle-thin"></i><?php echo app('translator')->get('view_pages.country'); ?></a>
          </li>
          <?php endif; ?>

<!--     <?php if(auth()->user()->can('view-email-templates')): ?>
          <li class="<?php echo e('mail_templates' == $sub_menu ? 'active' : ''); ?>">
            <a href="<?php echo e(url('/mail_templates')); ?>"><i class="fa fa-circle-thin"></i><?php echo app('translator')->get('pages_names.mail_templates'); ?></a>
          </li>
          <?php endif; ?>   -->
        </ul>
      </li>
      <?php endif; ?>

     <?php if(auth()->user()->can('master-data')): ?>
      <li class="treeview <?php echo e('master' == $main_menu ? 'active menu-open' : ''); ?>">
        <a href="javascript: void(0);">
          <i class="fa fa-code-fork"></i>
          <span> <?php echo app('translator')->get('pages_names.master'); ?> </span>
          <span class="pull-right-container">
            <i class="fa fa-angle-right pull-right"></i>
          </span>
        </a>

          <ul class="treeview-menu">
          <?php if(auth()->user()->can('manage-driver-needed-document')): ?>
          <li class="<?php echo e('needed_document' == $sub_menu ? 'active' : ''); ?>">
            <a href="<?php echo e(url('/needed_doc')); ?>"><i class="fa fa-circle-thin"></i><?php echo app('translator')->get('pages_names.needed_doc'); ?></a>
          </li>
          <?php endif; ?>
          <?php if(auth()->user()->can('manage-owner-needed-document')): ?>
          <li class="<?php echo e('owner_needed_document' == $sub_menu ? 'active' : ''); ?>">
            <a href="<?php echo e(url('/owner_needed_doc')); ?>"><i class="fa fa-circle-thin"></i><?php echo app('translator')->get('pages_names.owner_needed_doc'); ?></a>
          </li>
          <?php endif; ?>
          <?php if(auth()->user()->can('manage-fleet-needed-document')): ?>
          <li class="<?php echo e('fleet_needed_document' == $sub_menu ? 'active' : ''); ?>">
            <a href="<?php echo e(url('/fleet_needed_doc')); ?>"><i class="fa fa-circle-thin"></i><?php echo app('translator')->get('pages_names.fleet_needed_doc'); ?></a>
          </li>
          <?php endif; ?>
          <?php if(auth()->user()->can('manage-goods-types')  && ($app_for !== 'taxi')): ?>
                <li class="<?php echo e('goods_type' == $sub_menu ? 'active' : ''); ?>">
                    <a href="<?php echo e(url('/goods-types')); ?>"><i class="fa fa-circle-thin"></i><?php echo app('translator')->get('pages_names.goods_types'); ?></a>
                </li>
          <?php endif; ?>
          <?php if(auth()->user()->can('package-type')): ?>
          <li class="<?php echo e('package_type' == $sub_menu ? 'active' : ''); ?>">
            <a href="<?php echo e(url('/package_type')); ?>"><i class="fa fa-circle-thin"></i><?php echo app('translator')->get('pages_names.package_type'); ?></a>
          </li>
          <?php endif; ?>
          <?php if(auth()->user()->can('banner-image')): ?>
          <li class="<?php echo e('banner_image' == $sub_menu ? 'active' : ''); ?>">
            <a href="<?php echo e(url('/banner_image')); ?>"><i class="fa fa-circle-thin"></i><?php echo app('translator')->get('pages_names.banner_image'); ?></a>
          </li>
          <?php endif; ?>

        </ul>
      </li>
      <?php endif; ?>

      <?php if(auth()->user()->can('service_location')): ?>
      <li class="<?php echo e('service_location' == $main_menu ? 'active' : ''); ?>">
        <a href="<?php echo e(url('/service_location')); ?>">
          <i class="fa fa-map-marker"></i> <span><?php echo app('translator')->get('pages_names.service_location'); ?></span>
        </a>
      </li>
      <?php endif; ?>

      <?php
        $areas = App\Models\Admin\ServiceLocation::companyKey()->active(true)->get();
      ?>

        <?php if(auth()->user()->can('manage-owner')): ?>
        <li class="treeview <?php echo e('manage_owners' == $main_menu ? 'active menu-open' : ''); ?>">
        <a href="javascript: void(0);">
          <i class="fa fa-code-fork"></i>
          <span> <?php echo app('translator')->get('pages_names.owners'); ?> </span>
          <span class="pull-right-container">
            <i class="fa fa-angle-right pull-right"></i>
          </span>
        </a>
         <ul class="treeview-menu">
         <?php $__currentLoopData = $areas; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
          <li class="<?php echo e($sub_menu == $item->name ? 'active' : ''); ?>" data-id="<?php echo e($item->id); ?>">
            <a href="<?php echo e(url('/owners/by_area',$item->id)); ?>"><i class="fa fa-circle-thin"></i><?php echo e(ucfirst($item->name)); ?></a>
          </li>
           <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
         </ul>

            </li>

            <?php endif; ?>


             <?php if(auth()->user()->can('manage-fleet')): ?>
            <li class="<?php echo e($main_menu == 'manage_fleet' ? 'active' : ''); ?>">
                <a href="<?php echo e(route('viewFleet')); ?>">
                    <i class="fa fa-bus"></i>
                    <span> <?php echo e(trans('pages_names.manage_fleet')); ?> </span>
                </a>
            </li>
            <?php endif; ?>

      <?php if(auth()->user()->can('admin')): ?>
      <li class="<?php echo e('admin' == $main_menu ? 'active' : ''); ?>">
        <a href="<?php echo e(url('/admins')); ?>">
          <i class="fa fa-user-circle-o"></i> <span><?php echo app('translator')->get('pages_names.admins'); ?></span>
        </a>
      </li>
      <?php endif; ?>
         <?php if(auth()->user()->can('view-requests') && ($app_for !== 'delivery')): ?>
        <li class="treeview <?php echo e('trip-request' == $main_menu ? 'active menu-open' : ''); ?>">
          <a href="javascript: void(0);">
            <i class="fa fa-map"></i>
            <span> <?php echo app('translator')->get('pages_names.request'); ?> </span>
            <span class="pull-right-container">
              <i class="fa fa-angle-right pull-right"></i>
            </span>
          </a>

          <ul class="treeview-menu">
         <?php if(auth()->user()->can('view-rides')): ?>

            <li class="<?php echo e('request' == $sub_menu ? 'active' : ''); ?>">
              <a href="<?php echo e(url('/requests')); ?>">
                <i class="fa fa-circle-thin"></i> <span><?php echo app('translator')->get('pages_names.rides'); ?></span>
              </a>
            </li>
          <?php endif; ?>
         <?php if(auth()->user()->can('scheduled-rides')): ?>
            <li class="<?php echo e('scheduled-rides' == $sub_menu ? 'active' : ''); ?>">
              <a href="<?php echo e(url('/scheduled-rides')); ?>">
                <i class="fa fa-circle-thin"></i> <span><?php echo app('translator')->get('pages_names.scheduled_rides'); ?></span>
              </a>
            </li>
          <?php endif; ?>
          <?php if(auth()->user()->can('out-station-rides')): ?>
          <li class="<?php echo e('out-station-rides' == $sub_menu ? 'active' : ''); ?>">
            <a href="<?php echo e(url('/out-station-rides')); ?>">
              <i class="fa fa-circle-thin"></i> <span><?php echo app('translator')->get('pages_names.out_station_rides'); ?></span>
            </a>
          </li>
        <?php endif; ?>


         <?php if(auth()->user()->can('cancellation-rides')): ?>
            <li class="<?php echo e('cancellation-rides' == $sub_menu ? 'active' : ''); ?>">
              <a href="<?php echo e(url('/cancellation-rides')); ?>">
                <i class="fa fa-circle-thin"></i> <span><?php echo app('translator')->get('pages_names.cancellation_rides'); ?></span>
              </a>
            </li>
          <?php endif; ?>

          </ul>
        </li>
         <?php endif; ?>

         <?php if(auth()->user()->can('view-delivery-requests') && ($app_for !== 'taxi')): ?>
        <li class="treeview <?php echo e('delivery-trip-request' == $main_menu ? 'active menu-open' : ''); ?>">
          <a href="javascript: void(0);">
            <i class="fa fa-map"></i>
            <span> <?php echo app('translator')->get('pages_names.delivery_request'); ?> </span>
            <span class="pull-right-container">
              <i class="fa fa-angle-right pull-right"></i>
            </span>
          </a>

          <ul class="treeview-menu">
         <?php if(auth()->user()->can('view-delivery-rides')): ?>

            <li class="<?php echo e('delivery-request' == $sub_menu ? 'active' : ''); ?>">
              <a href="<?php echo e(url('/delivery-requests')); ?>">
                <i class="fa fa-circle-thin"></i> <span><?php echo app('translator')->get('pages_names.rides'); ?></span>
              </a>
            </li>
          <?php endif; ?>
         <?php if(auth()->user()->can('scheduled-delivery-rides')): ?>
            <li class="<?php echo e('scheduled-rides' == $sub_menu ? 'active' : ''); ?>">
              <a href="<?php echo e(url('/scheduled-delivery-rides')); ?>">
                <i class="fa fa-circle-thin"></i> <span><?php echo app('translator')->get('pages_names.scheduled_rides'); ?></span>
              </a>
            </li>
          <?php endif; ?>

         <?php if(auth()->user()->can('cancellation-delivery-rides')): ?>
            <li class="<?php echo e('cancellation-rides' == $sub_menu ? 'active' : ''); ?>">
              <a href="<?php echo e(url('/cancellation-delivery-rides')); ?>">
                <i class="fa fa-circle-thin"></i> <span><?php echo app('translator')->get('pages_names.cancellation_rides'); ?></span>
              </a>
            </li>
          <?php endif; ?>

          </ul>
        </li>
         <?php endif; ?>

      <?php if(auth()->user()->can('view-types')): ?>
      <li class="<?php echo e('types' == $main_menu ? 'active' : ''); ?>">
        <a href="<?php echo e(url('/types')); ?>">
          <i class="fa fa-taxi "></i> <span><?php echo app('translator')->get('pages_names.types'); ?></span>
        </a>
      </li>
      <?php endif; ?>

        <?php if(auth()->user()->can('map-menu')): ?>
        <li class="treeview <?php echo e('map' == $main_menu ? 'active menu-open' : ''); ?>">
          <a href="javascript: void(0);">
            <i class="fa fa-map"></i>
            <span> <?php echo app('translator')->get('pages_names.map'); ?> </span>
            <span class="pull-right-container">
              <i class="fa fa-angle-right pull-right"></i>
            </span>
          </a>
          <ul class="treeview-menu">
            <?php if(auth()->user()->can('view-zone')): ?>
            <li class="<?php echo e('zone' == $sub_menu ? 'active' : ''); ?>">
              <a href="<?php echo e(url('/zone')); ?>"><i class="fa fa-circle-thin"></i><?php echo app('translator')->get('pages_names.zone'); ?></a>
            </li>
            <?php endif; ?>
            <?php if(auth()->user()->can('list-airports')): ?>
            <li class="<?php echo e('airport' == $sub_menu ? 'active' : ''); ?>">
              <a href="<?php echo e(url('/airport')); ?>"><i class="fa fa-circle-thin"></i><?php echo app('translator')->get('pages_names.airport'); ?></a>
            </li>
            <?php endif; ?>

          </ul>
        </li>
      <?php endif; ?>
      <?php
        $zones = App\Models\Admin\Zone::companyKey()->active(true)->get();
      ?>

        <?php if(auth()->user()->can('vehicle-fare')): ?>
     <li class="treeview <?php echo e('vehicle-fare' == $main_menu ? 'active menu-open' : ''); ?>">
        <a href="javascript: void(0);">
          <i class="fa fa-money"></i>
          <span> <?php echo app('translator')->get('pages_names.set_price'); ?> </span>
          <span class="pull-right-container">
            <i class="fa fa-angle-right pull-right"></i>
          </span>
        </a>
         <ul class="treeview-menu">
         <?php $__currentLoopData = $zones; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
          <li class="<?php echo e($sub_menu == $item->name ? 'active' : ''); ?>" data-id="<?php echo e($item->id); ?>">
            <a href="<?php echo e(url('/vehicle_fare/by_zone',$item->id)); ?>"><i class="fa fa-circle-thin"></i><?php echo e(ucfirst($item->name)); ?></a>
          </li>
           <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
         </ul>
       </li>
      <?php endif; ?>
     <?php if(auth()->user()->can('drivers-menu')): ?>
              <?php if(auth()->user()->hasRole('owner')): ?>
                  <?php
                      $route = 'company/drivers';
                  ?>
              <?php else: ?>
                  <?php
                      $route = 'drivers';
                  ?>
      <?php endif; ?>


        <li class="treeview <?php echo e('drivers' == $main_menu ? 'active menu-open' : ''); ?>">
          <a href="javascript: void(0);">
            <i class="fa fa-users"></i>
            <span> <?php echo app('translator')->get('pages_names.drivers'); ?> </span>
            <span class="pull-right-container">
              <i class="fa fa-angle-right pull-right"></i>
            </span>
          </a>

          <ul class="treeview-menu">
           <?php if(auth()->user()->hasRole('owner')): ?>
              <?php if(auth()->user()->can('view-drivers')): ?>
              <li class="<?php echo e('driver_details' == $sub_menu ? 'active' : ''); ?>">
                <a href="<?php echo e(url($route)); ?>"><i class="fa fa-circle-thin"></i><?php echo app('translator')->get('pages_names.drivers'); ?></a>
              </li>
              <?php endif; ?>

           <?php else: ?>

           <?php if(auth()->user()->can('view-drivers')): ?>
            <li class="<?php echo e('driver_details' == $sub_menu ? 'active' : ''); ?>">
              <a href="<?php echo e(url($route)); ?>"><i class="fa fa-circle-thin"></i><?php echo app('translator')->get('pages_names.approved_drivers'); ?></a>
            </li>
            <?php endif; ?>

            <?php endif; ?>

            <?php if(auth()->user()->can('view-approval-pending-drivers')): ?>
            <li class="<?php echo e('driver_approval_pending' == $sub_menu ? 'active' : ''); ?>">
              <a href="<?php echo e(url('/drivers/waiting-for-approval')); ?>"><i class="fa fa-circle-thin"></i><?php echo app('translator')->get('pages_names.pending_approvals'); ?></a>
            </li>
            <?php endif; ?>
            <?php if(auth()->user()->can('drivers')): ?>
            <li class="<?php echo e('deleted_drivers' == $sub_menu ? 'active' : ''); ?>">
              <a href="<?php echo e(url('/drivers/deleted_drivers')); ?>"><i class="fa fa-circle-thin"></i><?php echo app('translator')->get('pages_names.deleted_drivers'); ?></a>
            </li>
            <?php endif; ?>
            <?php if(auth()->user()->can('view-driver-ratings')): ?>
            <li class="<?php echo e('driver_ratings' == $sub_menu ? 'active' : ''); ?>">
              <a href="<?php echo e(url('/driver-ratings')); ?>"><i class="fa fa-circle-thin"></i><?php echo app('translator')->get('pages_names.driver_ratings'); ?></a>
            </li>
            <?php endif; ?>
            <?php if(auth()->user()->can('view-driver-withdrawal-requests')): ?>
            <li class="<?php echo e('withdrawal_requests' == $sub_menu ? 'active' : ''); ?>">
              <a href="<?php echo e(url('/withdrawal-requests-lists')); ?>"><i class="fa fa-circle-thin"></i><?php echo app('translator')->get('pages_names.withdrawal_requests'); ?></a>
            </li>
            <?php endif; ?>
            <?php if(auth()->user()->can('view-negative-balance-drivers')): ?>
            <li class="<?php echo e('negative_balance_drivers' == $sub_menu ? 'active' : ''); ?>">
              <a href="<?php echo e(url('withdrawal-requests-lists/negative_balance_drivers')); ?>"><i class="fa fa-circle-thin"></i><?php echo app('translator')->get('pages_names.negative_balance_drivers'); ?></a>
            </li>
            <?php endif; ?>
          </ul>

        </li>
        <?php endif; ?>
       <?php if(auth()->user()->can('fleet-drivers-menu')): ?>
              <?php if(auth()->user()->hasRole('owner')): ?>
                  <?php
                      $route = 'company/drivers';
                  ?>
              <?php else: ?>
                  <?php
                      $route = 'fleet-drivers';
                  ?>
              <?php endif; ?>


        <li class="treeview <?php echo e('fleet-drivers' == $main_menu ? 'active menu-open' : ''); ?>">
          <a href="javascript: void(0);">
            <i class="fa fa-users"></i>
            <span> <?php echo app('translator')->get('pages_names.fleet_drivers'); ?> </span>
            <span class="pull-right-container">
              <i class="fa fa-angle-right pull-right"></i>
            </span>
          </a>

          <ul class="treeview-menu">
            <?php if(auth()->user()->can('view-approved-fleet-drivers')): ?>
            <li class="<?php echo e('driver_details' == $sub_menu ? 'active' : ''); ?>">
              <a href="<?php echo e(url($route)); ?>"><i class="fa fa-circle-thin"></i><?php echo app('translator')->get('pages_names.approved_fleet_drivers'); ?></a>
            </li>
            <?php endif; ?>

            <?php if(auth()->user()->can('fleet-drivers-waiting-for-approval')): ?>
            <li class="<?php echo e('driver_approval_pending' == $sub_menu ? 'active' : ''); ?>">
              <a href="<?php echo e(url('/fleet-drivers/waiting-for-approval')); ?>"><i class="fa fa-circle-thin"></i><?php echo app('translator')->get('pages_names.pending_approvals'); ?></a>
            </li>
            <?php endif; ?>
          </ul>

        </li>
      <?php endif; ?>
      <?php if(auth()->user()->can('user-menu')): ?>
      <li class="treeview <?php echo e('users' == $main_menu ? 'active menu-open' : ''); ?>">
        <a href="javascript: void(0);">
          <i class="fa fa-user"></i>
          <span> <?php echo app('translator')->get('pages_names.users'); ?> </span>
          <span class="pull-right-container">
            <i class="fa fa-angle-right pull-right"></i>
          </span>
        </a>

        <ul class="treeview-menu">
          <?php if(auth()->user()->can('view-users')): ?>
          <li class="<?php echo e('user_details' == $sub_menu ? 'active' : ''); ?>">
            <a href="<?php echo e(url('/users')); ?>"><i class="fa fa-circle-thin"></i><?php echo app('translator')->get('pages_names.user_details'); ?></a>
          </li>
          <?php endif; ?>
          <?php if(auth()->user()->can('view-delete-users')): ?>
          <li class="<?php echo e('user_details' == $sub_menu ? 'active' : ''); ?>">
            <a href="<?php echo e(url('/users/deleted')); ?>"><i class="fa fa-circle-thin"></i><?php echo app('translator')->get('pages_names.deleted_users'); ?></a>
          </li>
          <?php endif; ?>
        </ul>
      </li>
      <?php endif; ?>

      <?php if(auth()->user()->can('view-sos')): ?>
      <li class="<?php echo e('emergency_number' == $main_menu ? 'active' : ''); ?>">
        <a href="<?php echo e(url('/sos')); ?>">
          <i class="fa fa-heartbeat"></i> <span><?php echo app('translator')->get('pages_names.emergency_number'); ?></span>
        </a>
      </li>
      <?php endif; ?>
      <?php if(auth()->user()->can('chat')): ?>
      <li class="<?php echo e('chat_module' == $main_menu ? 'active' : ''); ?>">
        <a href="<?php echo e(url('/chat')); ?>">
          <i class="fa fa-question-circle"></i> <span><?php echo app('translator')->get('pages_names.live_chat'); ?></span>
        </a>
      </li>
        <?php endif; ?>

      <?php if(auth()->user()->can('manage-promo')): ?>
      <li class="<?php echo e('manage-promo' == $main_menu ? 'active' : ''); ?>">
        <a href="<?php echo e(url('/promo')); ?>">
          <i class="fa fa-gift"></i> <span><?php echo app('translator')->get('pages_names.promo_codes'); ?></span>
        </a>
      </li>
      <?php endif; ?>

      <?php if(auth()->user()->can('notifications')): ?>
      <li class="treeview <?php echo e('notifications' == $main_menu ? 'active menu-open' : ''); ?>">
        <a href="javascript: void(0);">
          <i class="fa fa-paper-plane"></i>
          <span> <?php echo app('translator')->get('pages_names.notifications'); ?> </span>
          <span class="pull-right-container">
            <i class="fa fa-angle-right pull-right"></i>
          </span>
        </a>

        <ul class="treeview-menu">
          <?php if(auth()->user()->can('view-notifications')): ?>
          <li class="<?php echo e('push_notification' == $sub_menu ? 'active' : ''); ?>">
            <a href="<?php echo e(url('/notifications/push')); ?>"><i class="fa fa-circle-thin"></i><?php echo app('translator')->get('pages_names.push_notification'); ?></a>
          </li>
          <?php endif; ?>
        </ul>
      </li>
      <?php endif; ?>

      <?php if(auth()->user()->can('cancellation-reason')): ?>
      <li class="<?php echo e('cancellation-reason' == $main_menu ? 'active' : ''); ?>">
        <a href="<?php echo e(url('/cancellation')); ?>">
          <i class="fa fa-ban"></i> <span><?php echo app('translator')->get('pages_names.cancellation'); ?></span>
        </a>
      </li>
      <?php endif; ?>

      <?php if(auth()->user()->can('complaints')): ?>
      <li class="treeview <?php echo e('complaints' == $main_menu ? 'active menu-open' : ''); ?>">
        <a href="javascript: void(0);">
          <i class="fa fa-list-alt"></i>
          <span> <?php echo app('translator')->get('pages_names.complaints'); ?> </span>
          <span class="pull-right-container">
            <i class="fa fa-angle-right pull-right"></i>
          </span>
        </a>

        <ul class="treeview-menu">
          <?php if(auth()->user()->can('complaint-title')): ?>
          <li class="<?php echo e('complaint-title' == $sub_menu ? 'active' : ''); ?>">
            <a href="<?php echo e(url('/complaint/title')); ?>"><i class="fa fa-circle-thin"></i><?php echo app('translator')->get('pages_names.complaint_title'); ?></a>
          </li>
          <?php endif; ?>

          <?php if(auth()->user()->can('user-complaint')): ?>
          <li class="treeview <?php echo e('user-complaint' == $sub_menu ? 'active' : ''); ?>">
             <a href="javascript: void(0);">
                <i class="fa fa-circle-thin"></i>
                <span> <?php echo app('translator')->get('pages_names.user_complaints'); ?> </span>
                <span class="pull-right-container">
                  <i class="fa fa-angle-right pull-right"></i>
                </span>
              </a>
             <ul class="treeview-menu">
               <li class="<?php echo e('user-general-complaint' == $sub_menu ? 'active' : ''); ?>">
            <a href="<?php echo e(url('/complaint/users/general')); ?>"><?php echo app('translator')->get('pages_names.general_complaints'); ?></a></li>

               <li class="<?php echo e('user-request-complaint' == $sub_menu ? 'active' : ''); ?>">
            <a href="<?php echo e(url('/complaint/users/request')); ?>"><?php echo app('translator')->get('pages_names.request_complaints'); ?></a></li>
             </ul>
          </li>
          <?php endif; ?>

          <?php if(auth()->user()->can('driver-complaint')): ?>
          <li class="treeview <?php echo e('driver-complaint' == $sub_menu ? 'active' : ''); ?>">
             <a href="javascript: void(0);">
                <i class="fa fa-circle-thin"></i>
                <span> <?php echo app('translator')->get('pages_names.driver_complaints'); ?> </span>
                <span class="pull-right-container">
                  <i class="fa fa-angle-right pull-right"></i>
                </span>
              </a>

            <ul class="treeview-menu">
               <li class="<?php echo e('driver-general-complaint' == $sub_menu ? 'active' : ''); ?>">
            <a href="<?php echo e(url('/complaint/drivers/general')); ?>"><?php echo app('translator')->get('pages_names.general_complaints'); ?></a></li>

               <li class="<?php echo e('driver-request-complaint' == $sub_menu ? 'active' : ''); ?>">
            <a href="<?php echo e(url('/complaint/drivers/request')); ?>"><?php echo app('translator')->get('pages_names.request_complaints'); ?></a></li>
             </ul>
          </li>
          <?php endif; ?>

          <?php if(auth()->user()->can('owner-complaint')): ?>
          <li class="treeview <?php echo e('owner-complaint' == $sub_menu ? 'active' : ''); ?>">
             <a href="javascript: void(0);">
                <i class="fa fa-circle-thin"></i>
                <span> <?php echo app('translator')->get('pages_names.owner_complaints'); ?> </span>
                <span class="pull-right-container">
                  <i class="fa fa-angle-right pull-right"></i>
                </span>
              </a>
             <ul class="treeview-menu">
               <li class="<?php echo e('owner-general-complaint' == $sub_menu ? 'active' : ''); ?>">
            <a href="<?php echo e(url('/complaint/owner/general')); ?>"><?php echo app('translator')->get('pages_names.general_complaints'); ?></a></li>

               <li class="<?php echo e('owner-request-complaint' == $sub_menu ? 'active' : ''); ?>">
            <a href="<?php echo e(url('/complaint/owner/request')); ?>"><?php echo app('translator')->get('pages_names.request_complaints'); ?></a></li>
             </ul>
          </li>
          <?php endif; ?>


        </ul>
      </li>
      <?php endif; ?>


      <?php if(auth()->user()->can('reports')): ?>
      <li class="treeview <?php echo e('reports' == $main_menu ? 'active menu-open' : ''); ?>">
        <a href="javascript: void(0);">
          <i class="fa fa-file-pdf-o"></i>
          <span> <?php echo app('translator')->get('pages_names.reports'); ?> </span>
          <span class="pull-right-container">
            <i class="fa fa-angle-right pull-right"></i>
          </span>
        </a>

        <ul class="treeview-menu">
          <?php if(auth()->user()->can('user-report')): ?>
          <li class="<?php echo e('user_report' == $sub_menu ? 'active' : ''); ?>">
            <a href="<?php echo e(url('/reports/user')); ?>"><i class="fa fa-circle-thin"></i><?php echo app('translator')->get('pages_names.user_report'); ?></a>
          </li>
          <?php endif; ?>

          <?php if(auth()->user()->can('driver-report')): ?>
          <li class="<?php echo e('driver_report' == $sub_menu ? 'active' : ''); ?>">
            <a href="<?php echo e(url('/reports/driver')); ?>"><i class="fa fa-circle-thin"></i><?php echo app('translator')->get('pages_names.driver_report'); ?></a>
          </li>
          <?php endif; ?>
          <?php if(auth()->user()->can('driver-duties-report')): ?>
         <!--  <li class="<?php echo e('driver_duties_report' == $sub_menu ? 'active' : ''); ?>">
            <a href="<?php echo e(url('/reports/driver-duties')); ?>"><i class="fa fa-circle-thin"></i><?php echo app('translator')->get('pages_names.driver_duties_report'); ?></a>
          </li> -->
          <?php endif; ?>

          <?php if(auth()->user()->can('owner-report')): ?>
          <li class="<?php echo e('owner_report' == $sub_menu ? 'active' : ''); ?>">
            <a href="<?php echo e(url('/reports/owner')); ?>"><i class="fa fa-circle-thin"></i><?php echo app('translator')->get('pages_names.owner_report'); ?></a>
          </li>
          <?php endif; ?>

          <?php if(auth()->user()->can('finance-report')): ?>
          <li class="<?php echo e('finance_report' == $sub_menu ? 'active' : ''); ?>">
            <a href="<?php echo e(url('/reports/travel')); ?>"><i class="fa fa-circle-thin"></i><?php echo app('translator')->get('pages_names.finance_report'); ?></a>
          </li>
          <?php endif; ?>
        </ul>
      </li>
      <?php endif; ?>

      <?php if(auth()->user()->can('manage-map')): ?>
      <li class="treeview <?php echo e('manage-map' == $main_menu ? 'active menu-open' : ''); ?>">
        <a href="javascript: void(0);">
          <i class="fa fa-globe"></i>
          <span> <?php echo app('translator')->get('pages_names.manage-map'); ?> </span>
          <span class="pull-right-container">
            <i class="fa fa-angle-right pull-right"></i>
          </span>
        </a>

        <ul class="treeview-menu">
          <?php if(auth()->user()->can('heat-map')): ?>
          <li class="<?php echo e('heat_map' == $sub_menu ? 'active' : ''); ?>">
            <a href="<?php echo e(url('map/heatmap')); ?>"><i class="fa fa-circle-thin"></i><?php echo app('translator')->get('pages_names.heat_map'); ?></a>
          </li>
          <?php endif; ?>

          <?php if(auth()->user()->can('map-view')): ?>
          <li class="<?php echo e('map' == $sub_menu ? 'active' : ''); ?>">
            <a href="<?php echo e(route('mapView')); ?>"><i class="fa fa-circle-thin"></i><?php echo app('translator')->get('pages_names.map_view'); ?></a>
          </li>

         
          <?php endif; ?>
        </ul>
      </li>
      <?php endif; ?>

      <?php if(auth()->user()->can('manage-faq')): ?>
      <li class="<?php echo e('faq' == $main_menu ? 'active' : ''); ?>">
        <a href="<?php echo e(url('/faq')); ?>">
          <i class="fa fa-question-circle"></i> <span><?php echo app('translator')->get('pages_names.faq'); ?></span>
        </a>
      </li>
      <?php endif; ?>

      
      


      <?php if(auth()->user()->can('cms')): ?>
      <li class="treeview <?php echo e('cms' == $main_menu ? 'active menu-open' : ''); ?>">
        <a href="javascript: void(0);">
          <i class="fa fa-file-pdf-o"></i>
          <span> CMS </span>
          <span class="pull-right-container">
            <i class="fa fa-angle-right pull-right"></i>
          </span>
        </a>
        <ul class="treeview-menu">
            
          <li class="<?php echo e('cms_frontpage' == $sub_menu ? 'active' : ''); ?>">
            <a href="<?php echo e(url('/cms/frontpagecms')); ?>"><i class="fa fa-circle-thin"></i><?php echo app('translator')->get('pages_names.home_page_cms'); ?></a>
          </li>
          <li class="<?php echo e('cms_safetypage' == $sub_menu ? 'active' : ''); ?>">
            <a href="<?php echo e(url('/cms/safetypagecms')); ?>"><i class="fa fa-circle-thin"></i><?php echo app('translator')->get('pages_names.safety_page_cms'); ?></a>
          </li>
          <li class="<?php echo e('cms_servicepage' == $sub_menu ? 'active' : ''); ?>">
            <a href="<?php echo e(url('/cms/servicepage')); ?>"><i class="fa fa-circle-thin"></i><?php echo app('translator')->get('pages_names.services_page_cms'); ?></a>
          </li>
          <li class="<?php echo e('cms_privacypage' == $sub_menu ? 'active' : ''); ?>">
            <a href="<?php echo e(url('/cms/privacypagecms')); ?>"><i class="fa fa-circle-thin"></i><?php echo app('translator')->get('pages_names.privacy_page_cms'); ?></a>
          </li>
          <li class="<?php echo e('cms_dmvpage' == $sub_menu ? 'active' : ''); ?>">
            <a href="<?php echo e(url('/cms/dmvpagecms')); ?>"><i class="fa fa-circle-thin"></i><?php echo app('translator')->get('pages_names.dmv_page_cms'); ?></a>
          </li>
          <li class="<?php echo e('cms_complaincepage' == $sub_menu ? 'active' : ''); ?>">
            <a href="<?php echo e(url('/cms/complaincepagecms')); ?>"><i class="fa fa-circle-thin"></i><?php echo app('translator')->get('pages_names.complaince_page_cms'); ?></a>
          </li>
          <li class="<?php echo e('cms_termspage' == $sub_menu ? 'active' : ''); ?>">
            <a href="<?php echo e(url('/cms/termspagecms')); ?>"><i class="fa fa-circle-thin"></i><?php echo app('translator')->get('pages_names.terms_page_cms'); ?></a>
          </li>
          <li class="<?php echo e('cms_drreqpage' == $sub_menu ? 'active' : ''); ?>">
            <a href="<?php echo e(url('/cms/drreqpagecms')); ?>"><i class="fa fa-circle-thin"></i><?php echo app('translator')->get('pages_names.driver_req_page_cms'); ?></a>
          </li>
          <li class="<?php echo e('cms_applydriverpage' == $sub_menu ? 'active' : ''); ?>">
            <a href="<?php echo e(url('/cms/applydriverpagecms')); ?>"><i class="fa fa-circle-thin"></i><?php echo app('translator')->get('pages_names.apply_to_drive'); ?></a>
          </li>
          <li class="<?php echo e('cms_howdriverpage' == $sub_menu ? 'active' : ''); ?>">
            <a href="<?php echo e(url('/cms/howdriverpagecms')); ?>"><i class="fa fa-circle-thin"></i><?php echo app('translator')->get('pages_names.how_it_works_page_cms'); ?></a>
          </li>
          <li class="<?php echo e('cms_contactpage' == $sub_menu ? 'active' : ''); ?>">
            <a href="<?php echo e(url('/cms/contactpagecms')); ?>"><i class="fa fa-circle-thin"></i><?php echo app('translator')->get('pages_names.contact_us_page_cms'); ?></a>
          </li>
          <li class="<?php echo e('cms_playstorepage' == $sub_menu ? 'active' : ''); ?>">
            <a href="<?php echo e(url('/cms/playstorepagecms')); ?>"><i class="fa fa-circle-thin"></i><?php echo app('translator')->get('pages_names.playstore_link_page_cms'); ?></a>
          </li>
          <li class="<?php echo e('cms_footerpage' == $sub_menu ? 'active' : ''); ?>">
            <a href="<?php echo e(url('/cms/footerpagecms')); ?>"><i class="fa fa-circle-thin"></i><?php echo app('translator')->get('pages_names.footer_page_cms'); ?></a>
          </li>
          <li class="<?php echo e('cms_colorthemepage' == $sub_menu ? 'active' : ''); ?>">
            <a href="<?php echo e(url('/cms/colorthemepagecms')); ?>"><i class="fa fa-circle-thin"></i><?php echo app('translator')->get('pages_names.color_theme_page_cms'); ?></a>
          </li>
          <li class="<?php echo e('cms_invoice' == $sub_menu ? 'active' : ''); ?>">
            <a href="<?php echo e(url('/cms/invoicecms')); ?>"><i class="fa fa-circle-thin"></i><?php echo app('translator')->get('pages_names.invoice_cms'); ?></a>
          </li>

        </ul>
      </li>
      <?php endif; ?>
     </ul>
  </section>
</aside>
<?php /**PATH C:\Users\khaled\Desktop\Main-File-April-09\server-app-April-9\resources\views/admin/layouts/navigation.blade.php ENDPATH**/ ?>